<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeviceSignalInfo StructType
 * @subpackage Structs
 */
class DeviceSignalInfo extends AbstractStructBase
{
    /**
     * The SummarizedSignalStrength
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SummarizedSignalStrength;
    /**
     * The SignalStrengthDateUTC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SignalStrengthDateUTC;
    /**
     * The LocalNetworkId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocalNetworkId;
    /**
     * Constructor method for DeviceSignalInfo
     * @uses DeviceSignalInfo::setSummarizedSignalStrength()
     * @uses DeviceSignalInfo::setSignalStrengthDateUTC()
     * @uses DeviceSignalInfo::setLocalNetworkId()
     * @param string $summarizedSignalStrength
     * @param string $signalStrengthDateUTC
     * @param string $localNetworkId
     */
    public function __construct($summarizedSignalStrength = null, $signalStrengthDateUTC = null, $localNetworkId = null)
    {
        $this
            ->setSummarizedSignalStrength($summarizedSignalStrength)
            ->setSignalStrengthDateUTC($signalStrengthDateUTC)
            ->setLocalNetworkId($localNetworkId);
    }
    /**
     * Get SummarizedSignalStrength value
     * @return string
     */
    public function getSummarizedSignalStrength()
    {
        return $this->SummarizedSignalStrength;
    }
    /**
     * Set SummarizedSignalStrength value
     * @uses \CustomerManagement\EnumType\LinkQualityGradeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\LinkQualityGradeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $summarizedSignalStrength
     * @return \CustomerManagement\StructType\DeviceSignalInfo
     */
    public function setSummarizedSignalStrength($summarizedSignalStrength = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\LinkQualityGradeEnum::valueIsValid($summarizedSignalStrength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\LinkQualityGradeEnum', is_array($summarizedSignalStrength) ? implode(', ', $summarizedSignalStrength) : var_export($summarizedSignalStrength, true), implode(', ', \CustomerManagement\EnumType\LinkQualityGradeEnum::getValidValues())), __LINE__);
        }
        $this->SummarizedSignalStrength = $summarizedSignalStrength;
        return $this;
    }
    /**
     * Get SignalStrengthDateUTC value
     * @return string
     */
    public function getSignalStrengthDateUTC()
    {
        return $this->SignalStrengthDateUTC;
    }
    /**
     * Set SignalStrengthDateUTC value
     * @param string $signalStrengthDateUTC
     * @return \CustomerManagement\StructType\DeviceSignalInfo
     */
    public function setSignalStrengthDateUTC($signalStrengthDateUTC = null)
    {
        // validation for constraint: string
        if (!is_null($signalStrengthDateUTC) && !is_string($signalStrengthDateUTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signalStrengthDateUTC, true), gettype($signalStrengthDateUTC)), __LINE__);
        }
        $this->SignalStrengthDateUTC = $signalStrengthDateUTC;
        return $this;
    }
    /**
     * Get LocalNetworkId value
     * @return string|null
     */
    public function getLocalNetworkId()
    {
        return $this->LocalNetworkId;
    }
    /**
     * Set LocalNetworkId value
     * @param string $localNetworkId
     * @return \CustomerManagement\StructType\DeviceSignalInfo
     */
    public function setLocalNetworkId($localNetworkId = null)
    {
        // validation for constraint: string
        if (!is_null($localNetworkId) && !is_string($localNetworkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localNetworkId, true), gettype($localNetworkId)), __LINE__);
        }
        $this->LocalNetworkId = $localNetworkId;
        return $this;
    }
}
