<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVideoAnalyticsRulesInfoOutput StructType
 * @subpackage Structs
 */
class GetVideoAnalyticsRulesInfoOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The NumberOfRules
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfRules;
    /**
     * The MonthlyUploadLimitClips
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MonthlyUploadLimitClips;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for GetVideoAnalyticsRulesInfoOutput
     * @uses GetVideoAnalyticsRulesInfoOutput::setSuccess()
     * @uses GetVideoAnalyticsRulesInfoOutput::setNumberOfRules()
     * @uses GetVideoAnalyticsRulesInfoOutput::setMonthlyUploadLimitClips()
     * @uses GetVideoAnalyticsRulesInfoOutput::setErrorMessage()
     * @param bool $success
     * @param int $numberOfRules
     * @param int $monthlyUploadLimitClips
     * @param string $errorMessage
     */
    public function __construct($success = null, $numberOfRules = null, $monthlyUploadLimitClips = null, $errorMessage = null)
    {
        $this
            ->setSuccess($success)
            ->setNumberOfRules($numberOfRules)
            ->setMonthlyUploadLimitClips($monthlyUploadLimitClips)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetVideoAnalyticsRulesInfoOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get NumberOfRules value
     * @return int
     */
    public function getNumberOfRules()
    {
        return $this->NumberOfRules;
    }
    /**
     * Set NumberOfRules value
     * @param int $numberOfRules
     * @return \CustomerManagement\StructType\GetVideoAnalyticsRulesInfoOutput
     */
    public function setNumberOfRules($numberOfRules = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfRules) && !(is_int($numberOfRules) || ctype_digit($numberOfRules))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfRules, true), gettype($numberOfRules)), __LINE__);
        }
        $this->NumberOfRules = $numberOfRules;
        return $this;
    }
    /**
     * Get MonthlyUploadLimitClips value
     * @return int
     */
    public function getMonthlyUploadLimitClips()
    {
        return $this->MonthlyUploadLimitClips;
    }
    /**
     * Set MonthlyUploadLimitClips value
     * @param int $monthlyUploadLimitClips
     * @return \CustomerManagement\StructType\GetVideoAnalyticsRulesInfoOutput
     */
    public function setMonthlyUploadLimitClips($monthlyUploadLimitClips = null)
    {
        // validation for constraint: int
        if (!is_null($monthlyUploadLimitClips) && !(is_int($monthlyUploadLimitClips) || ctype_digit($monthlyUploadLimitClips))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($monthlyUploadLimitClips, true), gettype($monthlyUploadLimitClips)), __LINE__);
        }
        $this->MonthlyUploadLimitClips = $monthlyUploadLimitClips;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetVideoAnalyticsRulesInfoOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
}
