<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddExistingLoginInput StructType
 * @subpackage Structs
 */
class AddExistingLoginInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The LoginId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LoginId;
    /**
     * Constructor method for AddExistingLoginInput
     * @uses AddExistingLoginInput::setCustomerId()
     * @uses AddExistingLoginInput::setLoginId()
     * @param int $customerId
     * @param int $loginId
     */
    public function __construct($customerId = null, $loginId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setLoginId($loginId);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\AddExistingLoginInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get LoginId value
     * @return int
     */
    public function getLoginId()
    {
        return $this->LoginId;
    }
    /**
     * Set LoginId value
     * @param int $loginId
     * @return \CustomerManagement\StructType\AddExistingLoginInput
     */
    public function setLoginId($loginId = null)
    {
        // validation for constraint: int
        if (!is_null($loginId) && !(is_int($loginId) || ctype_digit($loginId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loginId, true), gettype($loginId)), __LINE__);
        }
        $this->LoginId = $loginId;
        return $this;
    }
}
