<?php

namespace CustomerManagement\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Invalidate ServiceType
 * @subpackage Services
 */
class Invalidate extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \CustomerManagement\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\CustomerManagement\StructType\Authentication $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named InvalidateLoginTokens_v2
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Invalid the auto-login tokens for mobile devices for a login.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\InvalidateLoginTokens_v2 $parameters
     * @return \CustomerManagement\StructType\InvalidateLoginTokens_v2Response|bool
     */
    public function InvalidateLoginTokens_v2(\CustomerManagement\StructType\InvalidateLoginTokens_v2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InvalidateLoginTokens_v2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InvalidateLoginTokens
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Obsolete. Please call InvalidateLoginTokens_v2 instead.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\InvalidateLoginTokens $parameters
     * @return \CustomerManagement\StructType\InvalidateLoginTokensResponse|bool
     */
    public function InvalidateLoginTokens(\CustomerManagement\StructType\InvalidateLoginTokens $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InvalidateLoginTokens($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CustomerManagement\StructType\InvalidateLoginTokensResponse|\CustomerManagement\StructType\InvalidateLoginTokens_v2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
