<?php

namespace CustomerManagement\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \CustomerManagement\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\CustomerManagement\StructType\Authentication $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SetImageSensorSettings
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Configure settings for image sensor.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\SetImageSensorSettings $parameters
     * @return \CustomerManagement\StructType\SetImageSensorSettingsResponse|bool
     */
    public function SetImageSensorSettings(\CustomerManagement\StructType\SetImageSensorSettings $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetImageSensorSettings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetAutoPhoneTestSettings
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Set the auto-phone test parameters in the panel.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\SetAutoPhoneTestSettings $parameters
     * @return \CustomerManagement\StructType\SetAutoPhoneTestSettingsResponse|bool
     */
    public function SetAutoPhoneTestSettings(\CustomerManagement\StructType\SetAutoPhoneTestSettings $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetAutoPhoneTestSettings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetWifi
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Connect to the specified Wi-Fi network.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\SetWifi $parameters
     * @return \CustomerManagement\StructType\SetWifiResponse|bool
     */
    public function SetWifi(\CustomerManagement\StructType\SetWifi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetWifi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetVoiceAccessLevels
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Sets the customers voice access levels for PSU/Report State.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\SetVoiceAccessLevels $parameters
     * @return \CustomerManagement\StructType\SetVoiceAccessLevelsResponse|bool
     */
    public function SetVoiceAccessLevels(\CustomerManagement\StructType\SetVoiceAccessLevels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetVoiceAccessLevels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetAddOnQuantity
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Updates the quantity of an addon in the customer's service plan. Pass 0 to remove it, and 1 for addons that don't have quantities.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\SetAddOnQuantity $parameters
     * @return \CustomerManagement\StructType\SetAddOnQuantityResponse|bool
     */
    public function SetAddOnQuantity(\CustomerManagement\StructType\SetAddOnQuantity $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetAddOnQuantity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CustomerManagement\StructType\SetAddOnQuantityResponse|\CustomerManagement\StructType\SetAutoPhoneTestSettingsResponse|\CustomerManagement\StructType\SetImageSensorSettingsResponse|\CustomerManagement\StructType\SetVoiceAccessLevelsResponse|\CustomerManagement\StructType\SetWifiResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
