<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for FirmwareUpgradeEnum EnumType
 * @subpackage Enumerations
 */
class FirmwareUpgradeEnum
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'TwoGig15'
     * @return string 'TwoGig15'
     */
    const VALUE_TWO_GIG_15 = 'TwoGig15';
    /**
     * Constant for value 'TwoGig16'
     * @return string 'TwoGig16'
     */
    const VALUE_TWO_GIG_16 = 'TwoGig16';
    /**
     * Constant for value 'TwoGig18'
     * @return string 'TwoGig18'
     */
    const VALUE_TWO_GIG_18 = 'TwoGig18';
    /**
     * Constant for value 'TwoGig18French'
     * @return string 'TwoGig18French'
     */
    const VALUE_TWO_GIG_18_FRENCH = 'TwoGig18French';
    /**
     * Constant for value 'TwoGig19'
     * @return string 'TwoGig19'
     */
    const VALUE_TWO_GIG_19 = 'TwoGig19';
    /**
     * Constant for value 'TwoGig19French'
     * @return string 'TwoGig19French'
     */
    const VALUE_TWO_GIG_19_FRENCH = 'TwoGig19French';
    /**
     * Constant for value 'TwoGig19Spanish'
     * @return string 'TwoGig19Spanish'
     */
    const VALUE_TWO_GIG_19_SPANISH = 'TwoGig19Spanish';
    /**
     * Constant for value 'TwoGig1_10'
     * @return string 'TwoGig1_10'
     */
    const VALUE_TWO_GIG_1_10 = 'TwoGig1_10';
    /**
     * Constant for value 'TwoGig1_10French'
     * @return string 'TwoGig1_10French'
     */
    const VALUE_TWO_GIG_1_10_FRENCH = 'TwoGig1_10French';
    /**
     * Constant for value 'TwoGig1_10Spanish'
     * @return string 'TwoGig1_10Spanish'
     */
    const VALUE_TWO_GIG_1_10_SPANISH = 'TwoGig1_10Spanish';
    /**
     * Constant for value 'TwoGig1_12'
     * @return string 'TwoGig1_12'
     */
    const VALUE_TWO_GIG_1_12 = 'TwoGig1_12';
    /**
     * Constant for value 'TwoGig1_12French'
     * @return string 'TwoGig1_12French'
     */
    const VALUE_TWO_GIG_1_12_FRENCH = 'TwoGig1_12French';
    /**
     * Constant for value 'TwoGig1_12Spanish'
     * @return string 'TwoGig1_12Spanish'
     */
    const VALUE_TWO_GIG_1_12_SPANISH = 'TwoGig1_12Spanish';
    /**
     * Constant for value 'TwoGig1_12Portuguese'
     * @return string 'TwoGig1_12Portuguese'
     */
    const VALUE_TWO_GIG_1_12_PORTUGUESE = 'TwoGig1_12Portuguese';
    /**
     * Constant for value 'TwoGig1_13'
     * @return string 'TwoGig1_13'
     */
    const VALUE_TWO_GIG_1_13 = 'TwoGig1_13';
    /**
     * Constant for value 'TwoGig1_13French'
     * @return string 'TwoGig1_13French'
     */
    const VALUE_TWO_GIG_1_13_FRENCH = 'TwoGig1_13French';
    /**
     * Constant for value 'TwoGig1_13Spanish'
     * @return string 'TwoGig1_13Spanish'
     */
    const VALUE_TWO_GIG_1_13_SPANISH = 'TwoGig1_13Spanish';
    /**
     * Constant for value 'Neo1_14'
     * @return string 'Neo1_14'
     */
    const VALUE_NEO_1_14 = 'Neo1_14';
    /**
     * Constant for value 'TwoGig1_14'
     * @return string 'TwoGig1_14'
     */
    const VALUE_TWO_GIG_1_14 = 'TwoGig1_14';
    /**
     * Constant for value 'TwoGig1_14French'
     * @return string 'TwoGig1_14French'
     */
    const VALUE_TWO_GIG_1_14_FRENCH = 'TwoGig1_14French';
    /**
     * Constant for value 'TwoGig1_14Spanish'
     * @return string 'TwoGig1_14Spanish'
     */
    const VALUE_TWO_GIG_1_14_SPANISH = 'TwoGig1_14Spanish';
    /**
     * Constant for value 'TwoGig1_14Portuguese'
     * @return string 'TwoGig1_14Portuguese'
     */
    const VALUE_TWO_GIG_1_14_PORTUGUESE = 'TwoGig1_14Portuguese';
    /**
     * Constant for value 'TwoGig1_14Turkish'
     * @return string 'TwoGig1_14Turkish'
     */
    const VALUE_TWO_GIG_1_14_TURKISH = 'TwoGig1_14Turkish';
    /**
     * Constant for value 'NeoAllAvailableOta'
     * @return string 'NeoAllAvailableOta'
     */
    const VALUE_NEO_ALL_AVAILABLE_OTA = 'NeoAllAvailableOta';
    /**
     * Constant for value 'NeoFirstAvailableOta'
     * @return string 'NeoFirstAvailableOta'
     */
    const VALUE_NEO_FIRST_AVAILABLE_OTA = 'NeoFirstAvailableOta';
    /**
     * Constant for value 'ADC191Jand214Y'
     * @return string 'ADC191Jand214Y'
     */
    const VALUE_ADC_191_JAND_214_Y = 'ADC191Jand214Y';
    /**
     * Constant for value 'Neo185c'
     * @return string 'Neo185c'
     */
    const VALUE_NEO_185_C = 'Neo185c';
    /**
     * Constant for value 'Impassa181f'
     * @return string 'Impassa181f'
     */
    const VALUE_IMPASSA_181_F = 'Impassa181f';
    /**
     * Constant for value 'TwoGig1_17'
     * @return string 'TwoGig1_17'
     */
    const VALUE_TWO_GIG_1_17 = 'TwoGig1_17';
    /**
     * Constant for value 'TwoGig1_17French'
     * @return string 'TwoGig1_17French'
     */
    const VALUE_TWO_GIG_1_17_FRENCH = 'TwoGig1_17French';
    /**
     * Constant for value 'TwoGig1_17Spanish'
     * @return string 'TwoGig1_17Spanish'
     */
    const VALUE_TWO_GIG_1_17_SPANISH = 'TwoGig1_17Spanish';
    /**
     * Constant for value 'TwoGig1_17Portuguese'
     * @return string 'TwoGig1_17Portuguese'
     */
    const VALUE_TWO_GIG_1_17_PORTUGUESE = 'TwoGig1_17Portuguese';
    /**
     * Constant for value 'TwoGig1_17Turkish'
     * @return string 'TwoGig1_17Turkish'
     */
    const VALUE_TWO_GIG_1_17_TURKISH = 'TwoGig1_17Turkish';
    /**
     * Constant for value 'GoControl3_301_4402'
     * @return string 'GoControl3_301_4402'
     */
    const VALUE_GO_CONTROL_3_301_4402 = 'GoControl3_301_4402';
    /**
     * Constant for value 'SemPowerSeries231'
     * @return string 'SemPowerSeries231'
     */
    const VALUE_SEM_POWER_SERIES_231 = 'SemPowerSeries231';
    /**
     * Constant for value 'GoControl3_302_5036'
     * @return string 'GoControl3_302_5036'
     */
    const VALUE_GO_CONTROL_3_302_5036 = 'GoControl3_302_5036';
    /**
     * Constant for value 'Neo185d'
     * @return string 'Neo185d'
     */
    const VALUE_NEO_185_D = 'Neo185d';
    /**
     * Constant for value 'SimonXtZwave206'
     * @return string 'SimonXtZwave206'
     */
    const VALUE_SIMON_XT_ZWAVE_206 = 'SimonXtZwave206';
    /**
     * Constant for value 'Neo185e'
     * @return string 'Neo185e'
     */
    const VALUE_NEO_185_E = 'Neo185e';
    /**
     * Constant for value 'ADC192Band216E'
     * @return string 'ADC192Band216E'
     */
    const VALUE_ADC_192_BAND_216_E = 'ADC192Band216E';
    /**
     * Constant for value 'GoControl3_310_5572'
     * @return string 'GoControl3_310_5572'
     */
    const VALUE_GO_CONTROL_3_310_5572 = 'GoControl3_310_5572';
    /**
     * Constant for value 'Impassa131'
     * @return string 'Impassa131'
     */
    const VALUE_IMPASSA_131 = 'Impassa131';
    /**
     * Constant for value 'Neo187e'
     * @return string 'Neo187e'
     */
    const VALUE_NEO_187_E = 'Neo187e';
    /**
     * Constant for value 'GoControl3_311_5862'
     * @return string 'GoControl3_311_5862'
     */
    const VALUE_GO_CONTROL_3_311_5862 = 'GoControl3_311_5862';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_TWO_GIG_15
     * @uses self::VALUE_TWO_GIG_16
     * @uses self::VALUE_TWO_GIG_18
     * @uses self::VALUE_TWO_GIG_18_FRENCH
     * @uses self::VALUE_TWO_GIG_19
     * @uses self::VALUE_TWO_GIG_19_FRENCH
     * @uses self::VALUE_TWO_GIG_19_SPANISH
     * @uses self::VALUE_TWO_GIG_1_10
     * @uses self::VALUE_TWO_GIG_1_10_FRENCH
     * @uses self::VALUE_TWO_GIG_1_10_SPANISH
     * @uses self::VALUE_TWO_GIG_1_12
     * @uses self::VALUE_TWO_GIG_1_12_FRENCH
     * @uses self::VALUE_TWO_GIG_1_12_SPANISH
     * @uses self::VALUE_TWO_GIG_1_12_PORTUGUESE
     * @uses self::VALUE_TWO_GIG_1_13
     * @uses self::VALUE_TWO_GIG_1_13_FRENCH
     * @uses self::VALUE_TWO_GIG_1_13_SPANISH
     * @uses self::VALUE_NEO_1_14
     * @uses self::VALUE_TWO_GIG_1_14
     * @uses self::VALUE_TWO_GIG_1_14_FRENCH
     * @uses self::VALUE_TWO_GIG_1_14_SPANISH
     * @uses self::VALUE_TWO_GIG_1_14_PORTUGUESE
     * @uses self::VALUE_TWO_GIG_1_14_TURKISH
     * @uses self::VALUE_NEO_ALL_AVAILABLE_OTA
     * @uses self::VALUE_NEO_FIRST_AVAILABLE_OTA
     * @uses self::VALUE_ADC_191_JAND_214_Y
     * @uses self::VALUE_NEO_185_C
     * @uses self::VALUE_IMPASSA_181_F
     * @uses self::VALUE_TWO_GIG_1_17
     * @uses self::VALUE_TWO_GIG_1_17_FRENCH
     * @uses self::VALUE_TWO_GIG_1_17_SPANISH
     * @uses self::VALUE_TWO_GIG_1_17_PORTUGUESE
     * @uses self::VALUE_TWO_GIG_1_17_TURKISH
     * @uses self::VALUE_GO_CONTROL_3_301_4402
     * @uses self::VALUE_SEM_POWER_SERIES_231
     * @uses self::VALUE_GO_CONTROL_3_302_5036
     * @uses self::VALUE_NEO_185_D
     * @uses self::VALUE_SIMON_XT_ZWAVE_206
     * @uses self::VALUE_NEO_185_E
     * @uses self::VALUE_ADC_192_BAND_216_E
     * @uses self::VALUE_GO_CONTROL_3_310_5572
     * @uses self::VALUE_IMPASSA_131
     * @uses self::VALUE_NEO_187_E
     * @uses self::VALUE_GO_CONTROL_3_311_5862
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_TWO_GIG_15,
            self::VALUE_TWO_GIG_16,
            self::VALUE_TWO_GIG_18,
            self::VALUE_TWO_GIG_18_FRENCH,
            self::VALUE_TWO_GIG_19,
            self::VALUE_TWO_GIG_19_FRENCH,
            self::VALUE_TWO_GIG_19_SPANISH,
            self::VALUE_TWO_GIG_1_10,
            self::VALUE_TWO_GIG_1_10_FRENCH,
            self::VALUE_TWO_GIG_1_10_SPANISH,
            self::VALUE_TWO_GIG_1_12,
            self::VALUE_TWO_GIG_1_12_FRENCH,
            self::VALUE_TWO_GIG_1_12_SPANISH,
            self::VALUE_TWO_GIG_1_12_PORTUGUESE,
            self::VALUE_TWO_GIG_1_13,
            self::VALUE_TWO_GIG_1_13_FRENCH,
            self::VALUE_TWO_GIG_1_13_SPANISH,
            self::VALUE_NEO_1_14,
            self::VALUE_TWO_GIG_1_14,
            self::VALUE_TWO_GIG_1_14_FRENCH,
            self::VALUE_TWO_GIG_1_14_SPANISH,
            self::VALUE_TWO_GIG_1_14_PORTUGUESE,
            self::VALUE_TWO_GIG_1_14_TURKISH,
            self::VALUE_NEO_ALL_AVAILABLE_OTA,
            self::VALUE_NEO_FIRST_AVAILABLE_OTA,
            self::VALUE_ADC_191_JAND_214_Y,
            self::VALUE_NEO_185_C,
            self::VALUE_IMPASSA_181_F,
            self::VALUE_TWO_GIG_1_17,
            self::VALUE_TWO_GIG_1_17_FRENCH,
            self::VALUE_TWO_GIG_1_17_SPANISH,
            self::VALUE_TWO_GIG_1_17_PORTUGUESE,
            self::VALUE_TWO_GIG_1_17_TURKISH,
            self::VALUE_GO_CONTROL_3_301_4402,
            self::VALUE_SEM_POWER_SERIES_231,
            self::VALUE_GO_CONTROL_3_302_5036,
            self::VALUE_NEO_185_D,
            self::VALUE_SIMON_XT_ZWAVE_206,
            self::VALUE_NEO_185_E,
            self::VALUE_ADC_192_BAND_216_E,
            self::VALUE_GO_CONTROL_3_310_5572,
            self::VALUE_IMPASSA_131,
            self::VALUE_NEO_187_E,
            self::VALUE_GO_CONTROL_3_311_5862,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
