<?php

namespace CustomerManagement\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \CustomerManagement\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\CustomerManagement\StructType\Authentication $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named AddExistingLogins
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Add an existing login to a new customer to provide that login access to a new account.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddExistingLogins $parameters
     * @return \CustomerManagement\StructType\AddExistingLoginsResponse|bool
     */
    public function AddExistingLogins(\CustomerManagement\StructType\AddExistingLogins $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddExistingLogins($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddDefaultNotifications
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Add default notifications to a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddDefaultNotifications $parameters
     * @return \CustomerManagement\StructType\AddDefaultNotificationsResponse|bool
     */
    public function AddDefaultNotifications(\CustomerManagement\StructType\AddDefaultNotifications $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddDefaultNotifications($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSensorDevice
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: AddSensorDevice. The SensorTypeId field is only needed for Qolsys panels. When naming sensors use SensorNamePrefix for the NX panel; SensorName for Qolsys; and Base, Suffix, Token3, and Token4 for XT/XTi. Please call
     * GetEligibleSensorNames to get the valid descriptors for XT/XTi. SignalSource for Qolsys.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddSensorDevice $parameters
     * @return \CustomerManagement\StructType\AddSensorDeviceResponse|bool
     */
    public function AddSensorDevice(\CustomerManagement\StructType\AddSensorDevice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddSensorDevice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSensorDeviceFor2Gig
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Add 2Gig Sensor.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddSensorDeviceFor2Gig $parameters
     * @return \CustomerManagement\StructType\AddSensorDeviceFor2GigResponse|bool
     */
    public function AddSensorDeviceFor2Gig(\CustomerManagement\StructType\AddSensorDeviceFor2Gig $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddSensorDeviceFor2Gig($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddPeripheral
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Add Peripheral To Panel.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddPeripheral $parameters
     * @return \CustomerManagement\StructType\AddPeripheralResponse|bool
     */
    public function AddPeripheral(\CustomerManagement\StructType\AddPeripheral $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddPeripheral($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddVideoDevice
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Add Video Device.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddVideoDevice $parameters
     * @return \CustomerManagement\StructType\AddVideoDeviceResponse|bool
     */
    public function AddVideoDevice(\CustomerManagement\StructType\AddVideoDevice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddVideoDevice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddImageSensor
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Add Image Sensor.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddImageSensor $parameters
     * @return \CustomerManagement\StructType\AddImageSensorResponse|bool
     */
    public function AddImageSensor(\CustomerManagement\StructType\AddImageSensor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddImageSensor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSensorGetSensorVoiceDescriptors
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Returns a list of 2gig sensor voice descriptors.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddSensorGetSensorVoiceDescriptors $parameters
     * @return \CustomerManagement\StructType\AddSensorGetSensorVoiceDescriptorsResponse|bool
     */
    public function AddSensorGetSensorVoiceDescriptors(\CustomerManagement\StructType\AddSensorGetSensorVoiceDescriptors $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddSensorGetSensorVoiceDescriptors($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSensorGetSensorTypes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Returns a list of 2gig sensor types.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddSensorGetSensorTypes $parameters
     * @return \CustomerManagement\StructType\AddSensorGetSensorTypesResponse|bool
     */
    public function AddSensorGetSensorTypes(\CustomerManagement\StructType\AddSensorGetSensorTypes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddSensorGetSensorTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUserCode
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Add a new user code. Calling this method will send a notification to the customer that their user codes have changed.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddUserCode $parameters
     * @return \CustomerManagement\StructType\AddUserCodeResponse|bool
     */
    public function AddUserCode(\CustomerManagement\StructType\AddUserCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddUserCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUpdateZwaveDeviceSpecificKey
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Add/Update a Z-Wave device specific key (DSK) for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddUpdateZwaveDeviceSpecificKey $parameters
     * @return \CustomerManagement\StructType\AddUpdateZwaveDeviceSpecificKeyResponse|bool
     */
    public function AddUpdateZwaveDeviceSpecificKey(\CustomerManagement\StructType\AddUpdateZwaveDeviceSpecificKey $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddUpdateZwaveDeviceSpecificKey($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddCustomerToGroup
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddCustomerToGroup $parameters
     * @return \CustomerManagement\StructType\AddCustomerToGroupResponse|bool
     */
    public function AddCustomerToGroup(\CustomerManagement\StructType\AddCustomerToGroup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddCustomerToGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddCustomerLogin
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Add a new login to a customer account.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\AddCustomerLogin $parameters
     * @return \CustomerManagement\StructType\AddCustomerLoginResponse|bool
     */
    public function AddCustomerLogin(\CustomerManagement\StructType\AddCustomerLogin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddCustomerLogin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CustomerManagement\StructType\AddCustomerLoginResponse|\CustomerManagement\StructType\AddCustomerToGroupResponse|\CustomerManagement\StructType\AddDefaultNotificationsResponse|\CustomerManagement\StructType\AddExistingLoginsResponse|\CustomerManagement\StructType\AddImageSensorResponse|\CustomerManagement\StructType\AddPeripheralResponse|\CustomerManagement\StructType\AddSensorDeviceFor2GigResponse|\CustomerManagement\StructType\AddSensorDeviceResponse|\CustomerManagement\StructType\AddSensorGetSensorTypesResponse|\CustomerManagement\StructType\AddSensorGetSensorVoiceDescriptorsResponse|\CustomerManagement\StructType\AddUpdateZwaveDeviceSpecificKeyResponse|\CustomerManagement\StructType\AddUserCodeResponse|\CustomerManagement\StructType\AddVideoDeviceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
