<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemCheckOutput StructType
 * @subpackage Structs
 */
class SystemCheckOutput extends AbstractStructBase
{
    /**
     * The SystemCheckId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemCheckId;
    /**
     * The SystemCheckStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SystemCheckStartDate;
    /**
     * The SystemCheckEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SystemCheckEndDate;
    /**
     * The InitiatedRepId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InitiatedRepId;
    /**
     * The InitiatedLoginId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InitiatedLoginId;
    /**
     * The IsRunning
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsRunning;
    /**
     * The ShouldSendEnterpriseCodes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ShouldSendEnterpriseCodes;
    /**
     * The WasSendCodesSuccessful
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $WasSendCodesSuccessful;
    /**
     * The SendCodesAttemptedDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SendCodesAttemptedDateUtc;
    /**
     * The ForceStopped
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ForceStopped;
    /**
     * The TestCategories
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfSystemCheckCategoryOutput
     */
    public $TestCategories;
    /**
     * Constructor method for SystemCheckOutput
     * @uses SystemCheckOutput::setSystemCheckId()
     * @uses SystemCheckOutput::setSystemCheckStartDate()
     * @uses SystemCheckOutput::setSystemCheckEndDate()
     * @uses SystemCheckOutput::setInitiatedRepId()
     * @uses SystemCheckOutput::setInitiatedLoginId()
     * @uses SystemCheckOutput::setIsRunning()
     * @uses SystemCheckOutput::setShouldSendEnterpriseCodes()
     * @uses SystemCheckOutput::setWasSendCodesSuccessful()
     * @uses SystemCheckOutput::setSendCodesAttemptedDateUtc()
     * @uses SystemCheckOutput::setForceStopped()
     * @uses SystemCheckOutput::setTestCategories()
     * @param int $systemCheckId
     * @param string $systemCheckStartDate
     * @param string $systemCheckEndDate
     * @param int $initiatedRepId
     * @param int $initiatedLoginId
     * @param bool $isRunning
     * @param bool $shouldSendEnterpriseCodes
     * @param bool $wasSendCodesSuccessful
     * @param string $sendCodesAttemptedDateUtc
     * @param bool $forceStopped
     * @param \CustomerManagement\ArrayType\ArrayOfSystemCheckCategoryOutput $testCategories
     */
    public function __construct($systemCheckId = null, $systemCheckStartDate = null, $systemCheckEndDate = null, $initiatedRepId = null, $initiatedLoginId = null, $isRunning = null, $shouldSendEnterpriseCodes = null, $wasSendCodesSuccessful = null, $sendCodesAttemptedDateUtc = null, $forceStopped = null, \CustomerManagement\ArrayType\ArrayOfSystemCheckCategoryOutput $testCategories = null)
    {
        $this
            ->setSystemCheckId($systemCheckId)
            ->setSystemCheckStartDate($systemCheckStartDate)
            ->setSystemCheckEndDate($systemCheckEndDate)
            ->setInitiatedRepId($initiatedRepId)
            ->setInitiatedLoginId($initiatedLoginId)
            ->setIsRunning($isRunning)
            ->setShouldSendEnterpriseCodes($shouldSendEnterpriseCodes)
            ->setWasSendCodesSuccessful($wasSendCodesSuccessful)
            ->setSendCodesAttemptedDateUtc($sendCodesAttemptedDateUtc)
            ->setForceStopped($forceStopped)
            ->setTestCategories($testCategories);
    }
    /**
     * Get SystemCheckId value
     * @return int
     */
    public function getSystemCheckId()
    {
        return $this->SystemCheckId;
    }
    /**
     * Set SystemCheckId value
     * @param int $systemCheckId
     * @return \CustomerManagement\StructType\SystemCheckOutput
     */
    public function setSystemCheckId($systemCheckId = null)
    {
        // validation for constraint: int
        if (!is_null($systemCheckId) && !(is_int($systemCheckId) || ctype_digit($systemCheckId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($systemCheckId, true), gettype($systemCheckId)), __LINE__);
        }
        $this->SystemCheckId = $systemCheckId;
        return $this;
    }
    /**
     * Get SystemCheckStartDate value
     * @return string
     */
    public function getSystemCheckStartDate()
    {
        return $this->SystemCheckStartDate;
    }
    /**
     * Set SystemCheckStartDate value
     * @param string $systemCheckStartDate
     * @return \CustomerManagement\StructType\SystemCheckOutput
     */
    public function setSystemCheckStartDate($systemCheckStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($systemCheckStartDate) && !is_string($systemCheckStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemCheckStartDate, true), gettype($systemCheckStartDate)), __LINE__);
        }
        $this->SystemCheckStartDate = $systemCheckStartDate;
        return $this;
    }
    /**
     * Get SystemCheckEndDate value
     * @return string
     */
    public function getSystemCheckEndDate()
    {
        return $this->SystemCheckEndDate;
    }
    /**
     * Set SystemCheckEndDate value
     * @param string $systemCheckEndDate
     * @return \CustomerManagement\StructType\SystemCheckOutput
     */
    public function setSystemCheckEndDate($systemCheckEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($systemCheckEndDate) && !is_string($systemCheckEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemCheckEndDate, true), gettype($systemCheckEndDate)), __LINE__);
        }
        $this->SystemCheckEndDate = $systemCheckEndDate;
        return $this;
    }
    /**
     * Get InitiatedRepId value
     * @return int
     */
    public function getInitiatedRepId()
    {
        return $this->InitiatedRepId;
    }
    /**
     * Set InitiatedRepId value
     * @param int $initiatedRepId
     * @return \CustomerManagement\StructType\SystemCheckOutput
     */
    public function setInitiatedRepId($initiatedRepId = null)
    {
        // validation for constraint: int
        if (!is_null($initiatedRepId) && !(is_int($initiatedRepId) || ctype_digit($initiatedRepId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($initiatedRepId, true), gettype($initiatedRepId)), __LINE__);
        }
        $this->InitiatedRepId = $initiatedRepId;
        return $this;
    }
    /**
     * Get InitiatedLoginId value
     * @return int
     */
    public function getInitiatedLoginId()
    {
        return $this->InitiatedLoginId;
    }
    /**
     * Set InitiatedLoginId value
     * @param int $initiatedLoginId
     * @return \CustomerManagement\StructType\SystemCheckOutput
     */
    public function setInitiatedLoginId($initiatedLoginId = null)
    {
        // validation for constraint: int
        if (!is_null($initiatedLoginId) && !(is_int($initiatedLoginId) || ctype_digit($initiatedLoginId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($initiatedLoginId, true), gettype($initiatedLoginId)), __LINE__);
        }
        $this->InitiatedLoginId = $initiatedLoginId;
        return $this;
    }
    /**
     * Get IsRunning value
     * @return bool
     */
    public function getIsRunning()
    {
        return $this->IsRunning;
    }
    /**
     * Set IsRunning value
     * @param bool $isRunning
     * @return \CustomerManagement\StructType\SystemCheckOutput
     */
    public function setIsRunning($isRunning = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRunning) && !is_bool($isRunning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRunning, true), gettype($isRunning)), __LINE__);
        }
        $this->IsRunning = $isRunning;
        return $this;
    }
    /**
     * Get ShouldSendEnterpriseCodes value
     * @return bool
     */
    public function getShouldSendEnterpriseCodes()
    {
        return $this->ShouldSendEnterpriseCodes;
    }
    /**
     * Set ShouldSendEnterpriseCodes value
     * @param bool $shouldSendEnterpriseCodes
     * @return \CustomerManagement\StructType\SystemCheckOutput
     */
    public function setShouldSendEnterpriseCodes($shouldSendEnterpriseCodes = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldSendEnterpriseCodes) && !is_bool($shouldSendEnterpriseCodes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldSendEnterpriseCodes, true), gettype($shouldSendEnterpriseCodes)), __LINE__);
        }
        $this->ShouldSendEnterpriseCodes = $shouldSendEnterpriseCodes;
        return $this;
    }
    /**
     * Get WasSendCodesSuccessful value
     * @return bool
     */
    public function getWasSendCodesSuccessful()
    {
        return $this->WasSendCodesSuccessful;
    }
    /**
     * Set WasSendCodesSuccessful value
     * @param bool $wasSendCodesSuccessful
     * @return \CustomerManagement\StructType\SystemCheckOutput
     */
    public function setWasSendCodesSuccessful($wasSendCodesSuccessful = null)
    {
        // validation for constraint: boolean
        if (!is_null($wasSendCodesSuccessful) && !is_bool($wasSendCodesSuccessful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wasSendCodesSuccessful, true), gettype($wasSendCodesSuccessful)), __LINE__);
        }
        $this->WasSendCodesSuccessful = $wasSendCodesSuccessful;
        return $this;
    }
    /**
     * Get SendCodesAttemptedDateUtc value
     * @return string
     */
    public function getSendCodesAttemptedDateUtc()
    {
        return $this->SendCodesAttemptedDateUtc;
    }
    /**
     * Set SendCodesAttemptedDateUtc value
     * @param string $sendCodesAttemptedDateUtc
     * @return \CustomerManagement\StructType\SystemCheckOutput
     */
    public function setSendCodesAttemptedDateUtc($sendCodesAttemptedDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($sendCodesAttemptedDateUtc) && !is_string($sendCodesAttemptedDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendCodesAttemptedDateUtc, true), gettype($sendCodesAttemptedDateUtc)), __LINE__);
        }
        $this->SendCodesAttemptedDateUtc = $sendCodesAttemptedDateUtc;
        return $this;
    }
    /**
     * Get ForceStopped value
     * @return bool
     */
    public function getForceStopped()
    {
        return $this->ForceStopped;
    }
    /**
     * Set ForceStopped value
     * @param bool $forceStopped
     * @return \CustomerManagement\StructType\SystemCheckOutput
     */
    public function setForceStopped($forceStopped = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceStopped) && !is_bool($forceStopped)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceStopped, true), gettype($forceStopped)), __LINE__);
        }
        $this->ForceStopped = $forceStopped;
        return $this;
    }
    /**
     * Get TestCategories value
     * @return \CustomerManagement\ArrayType\ArrayOfSystemCheckCategoryOutput|null
     */
    public function getTestCategories()
    {
        return $this->TestCategories;
    }
    /**
     * Set TestCategories value
     * @param \CustomerManagement\ArrayType\ArrayOfSystemCheckCategoryOutput $testCategories
     * @return \CustomerManagement\StructType\SystemCheckOutput
     */
    public function setTestCategories(\CustomerManagement\ArrayType\ArrayOfSystemCheckCategoryOutput $testCategories = null)
    {
        $this->TestCategories = $testCategories;
        return $this;
    }
}
