<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDeviceBatteryInfoOutput StructType
 * @subpackage Structs
 */
class GetDeviceBatteryInfoOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The BatteryInfoList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfDeviceBatteryInfo
     */
    public $BatteryInfoList;
    /**
     * Constructor method for GetDeviceBatteryInfoOutput
     * @uses GetDeviceBatteryInfoOutput::setSuccess()
     * @uses GetDeviceBatteryInfoOutput::setErrorMessage()
     * @uses GetDeviceBatteryInfoOutput::setBatteryInfoList()
     * @param bool $success
     * @param string $errorMessage
     * @param \CustomerManagement\ArrayType\ArrayOfDeviceBatteryInfo $batteryInfoList
     */
    public function __construct($success = null, $errorMessage = null, \CustomerManagement\ArrayType\ArrayOfDeviceBatteryInfo $batteryInfoList = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorMessage($errorMessage)
            ->setBatteryInfoList($batteryInfoList);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetDeviceBatteryInfoOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetDeviceBatteryInfoOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get BatteryInfoList value
     * @return \CustomerManagement\ArrayType\ArrayOfDeviceBatteryInfo|null
     */
    public function getBatteryInfoList()
    {
        return $this->BatteryInfoList;
    }
    /**
     * Set BatteryInfoList value
     * @param \CustomerManagement\ArrayType\ArrayOfDeviceBatteryInfo $batteryInfoList
     * @return \CustomerManagement\StructType\GetDeviceBatteryInfoOutput
     */
    public function setBatteryInfoList(\CustomerManagement\ArrayType\ArrayOfDeviceBatteryInfo $batteryInfoList = null)
    {
        $this->BatteryInfoList = $batteryInfoList;
        return $this;
    }
}
