<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditScheduledAppointmentInput StructType
 * @subpackage Structs
 */
class EditScheduledAppointmentInput extends AbstractStructBase
{
    /**
     * The AppointmentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AppointmentId;
    /**
     * The DateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateUtc;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The TechnicianId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TechnicianId;
    /**
     * The Confirmation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Confirmation;
    /**
     * The Reminder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Reminder;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * Constructor method for EditScheduledAppointmentInput
     * @uses EditScheduledAppointmentInput::setAppointmentId()
     * @uses EditScheduledAppointmentInput::setDateUtc()
     * @uses EditScheduledAppointmentInput::setStatus()
     * @uses EditScheduledAppointmentInput::setTechnicianId()
     * @uses EditScheduledAppointmentInput::setConfirmation()
     * @uses EditScheduledAppointmentInput::setReminder()
     * @uses EditScheduledAppointmentInput::setNotes()
     * @param int $appointmentId
     * @param string $dateUtc
     * @param string $status
     * @param int $technicianId
     * @param bool $confirmation
     * @param bool $reminder
     * @param string $notes
     */
    public function __construct($appointmentId = null, $dateUtc = null, $status = null, $technicianId = null, $confirmation = null, $reminder = null, $notes = null)
    {
        $this
            ->setAppointmentId($appointmentId)
            ->setDateUtc($dateUtc)
            ->setStatus($status)
            ->setTechnicianId($technicianId)
            ->setConfirmation($confirmation)
            ->setReminder($reminder)
            ->setNotes($notes);
    }
    /**
     * Get AppointmentId value
     * @return int
     */
    public function getAppointmentId()
    {
        return $this->AppointmentId;
    }
    /**
     * Set AppointmentId value
     * @param int $appointmentId
     * @return \CustomerManagement\StructType\EditScheduledAppointmentInput
     */
    public function setAppointmentId($appointmentId = null)
    {
        // validation for constraint: int
        if (!is_null($appointmentId) && !(is_int($appointmentId) || ctype_digit($appointmentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($appointmentId, true), gettype($appointmentId)), __LINE__);
        }
        $this->AppointmentId = $appointmentId;
        return $this;
    }
    /**
     * Get DateUtc value
     * @return string
     */
    public function getDateUtc()
    {
        return $this->DateUtc;
    }
    /**
     * Set DateUtc value
     * @param string $dateUtc
     * @return \CustomerManagement\StructType\EditScheduledAppointmentInput
     */
    public function setDateUtc($dateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($dateUtc) && !is_string($dateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateUtc, true), gettype($dateUtc)), __LINE__);
        }
        $this->DateUtc = $dateUtc;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \CustomerManagement\EnumType\ScheduledServiceDateStatus::valueIsValid()
     * @uses \CustomerManagement\EnumType\ScheduledServiceDateStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \CustomerManagement\StructType\EditScheduledAppointmentInput
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\ScheduledServiceDateStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\ScheduledServiceDateStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \CustomerManagement\EnumType\ScheduledServiceDateStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TechnicianId value
     * @return int
     */
    public function getTechnicianId()
    {
        return $this->TechnicianId;
    }
    /**
     * Set TechnicianId value
     * @param int $technicianId
     * @return \CustomerManagement\StructType\EditScheduledAppointmentInput
     */
    public function setTechnicianId($technicianId = null)
    {
        // validation for constraint: int
        if (!is_null($technicianId) && !(is_int($technicianId) || ctype_digit($technicianId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($technicianId, true), gettype($technicianId)), __LINE__);
        }
        $this->TechnicianId = $technicianId;
        return $this;
    }
    /**
     * Get Confirmation value
     * @return bool
     */
    public function getConfirmation()
    {
        return $this->Confirmation;
    }
    /**
     * Set Confirmation value
     * @param bool $confirmation
     * @return \CustomerManagement\StructType\EditScheduledAppointmentInput
     */
    public function setConfirmation($confirmation = null)
    {
        // validation for constraint: boolean
        if (!is_null($confirmation) && !is_bool($confirmation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($confirmation, true), gettype($confirmation)), __LINE__);
        }
        $this->Confirmation = $confirmation;
        return $this;
    }
    /**
     * Get Reminder value
     * @return bool
     */
    public function getReminder()
    {
        return $this->Reminder;
    }
    /**
     * Set Reminder value
     * @param bool $reminder
     * @return \CustomerManagement\StructType\EditScheduledAppointmentInput
     */
    public function setReminder($reminder = null)
    {
        // validation for constraint: boolean
        if (!is_null($reminder) && !is_bool($reminder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reminder, true), gettype($reminder)), __LINE__);
        }
        $this->Reminder = $reminder;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \CustomerManagement\StructType\EditScheduledAppointmentInput
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
}
