<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TroubleConditionsRestoresItem StructType
 * @subpackage Structs
 */
class TroubleConditionsRestoresItem extends AbstractStructBase
{
    /**
     * The Zone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Zone;
    /**
     * The Partition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Partition;
    /**
     * The IsRestored
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsRestored;
    /**
     * The TimestampUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TimestampUtc;
    /**
     * The Trouble
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Trouble;
    /**
     * Constructor method for TroubleConditionsRestoresItem
     * @uses TroubleConditionsRestoresItem::setZone()
     * @uses TroubleConditionsRestoresItem::setPartition()
     * @uses TroubleConditionsRestoresItem::setIsRestored()
     * @uses TroubleConditionsRestoresItem::setTimestampUtc()
     * @uses TroubleConditionsRestoresItem::setTrouble()
     * @param int $zone
     * @param int $partition
     * @param bool $isRestored
     * @param string $timestampUtc
     * @param string $trouble
     */
    public function __construct($zone = null, $partition = null, $isRestored = null, $timestampUtc = null, $trouble = null)
    {
        $this
            ->setZone($zone)
            ->setPartition($partition)
            ->setIsRestored($isRestored)
            ->setTimestampUtc($timestampUtc)
            ->setTrouble($trouble);
    }
    /**
     * Get Zone value
     * @return int
     */
    public function getZone()
    {
        return $this->Zone;
    }
    /**
     * Set Zone value
     * @param int $zone
     * @return \CustomerManagement\StructType\TroubleConditionsRestoresItem
     */
    public function setZone($zone = null)
    {
        // validation for constraint: int
        if (!is_null($zone) && !(is_int($zone) || ctype_digit($zone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zone, true), gettype($zone)), __LINE__);
        }
        $this->Zone = $zone;
        return $this;
    }
    /**
     * Get Partition value
     * @return int
     */
    public function getPartition()
    {
        return $this->Partition;
    }
    /**
     * Set Partition value
     * @param int $partition
     * @return \CustomerManagement\StructType\TroubleConditionsRestoresItem
     */
    public function setPartition($partition = null)
    {
        // validation for constraint: int
        if (!is_null($partition) && !(is_int($partition) || ctype_digit($partition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($partition, true), gettype($partition)), __LINE__);
        }
        $this->Partition = $partition;
        return $this;
    }
    /**
     * Get IsRestored value
     * @return bool
     */
    public function getIsRestored()
    {
        return $this->IsRestored;
    }
    /**
     * Set IsRestored value
     * @param bool $isRestored
     * @return \CustomerManagement\StructType\TroubleConditionsRestoresItem
     */
    public function setIsRestored($isRestored = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRestored) && !is_bool($isRestored)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRestored, true), gettype($isRestored)), __LINE__);
        }
        $this->IsRestored = $isRestored;
        return $this;
    }
    /**
     * Get TimestampUtc value
     * @return string
     */
    public function getTimestampUtc()
    {
        return $this->TimestampUtc;
    }
    /**
     * Set TimestampUtc value
     * @param string $timestampUtc
     * @return \CustomerManagement\StructType\TroubleConditionsRestoresItem
     */
    public function setTimestampUtc($timestampUtc = null)
    {
        // validation for constraint: string
        if (!is_null($timestampUtc) && !is_string($timestampUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestampUtc, true), gettype($timestampUtc)), __LINE__);
        }
        $this->TimestampUtc = $timestampUtc;
        return $this;
    }
    /**
     * Get Trouble value
     * @return string|null
     */
    public function getTrouble()
    {
        return $this->Trouble;
    }
    /**
     * Set Trouble value
     * @param string $trouble
     * @return \CustomerManagement\StructType\TroubleConditionsRestoresItem
     */
    public function setTrouble($trouble = null)
    {
        // validation for constraint: string
        if (!is_null($trouble) && !is_string($trouble)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trouble, true), gettype($trouble)), __LINE__);
        }
        $this->Trouble = $trouble;
        return $this;
    }
}
