<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSummarizedSignalStrengthForZWaveDevicesOutput
 * StructType
 * @subpackage Structs
 */
class GetSummarizedSignalStrengthForZWaveDevicesOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The SignalInfoList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfDeviceSignalInfo
     */
    public $SignalInfoList;
    /**
     * Constructor method for GetSummarizedSignalStrengthForZWaveDevicesOutput
     * @uses GetSummarizedSignalStrengthForZWaveDevicesOutput::setSuccess()
     * @uses GetSummarizedSignalStrengthForZWaveDevicesOutput::setErrorMessage()
     * @uses GetSummarizedSignalStrengthForZWaveDevicesOutput::setSignalInfoList()
     * @param bool $success
     * @param string $errorMessage
     * @param \CustomerManagement\ArrayType\ArrayOfDeviceSignalInfo $signalInfoList
     */
    public function __construct($success = null, $errorMessage = null, \CustomerManagement\ArrayType\ArrayOfDeviceSignalInfo $signalInfoList = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorMessage($errorMessage)
            ->setSignalInfoList($signalInfoList);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetSummarizedSignalStrengthForZWaveDevicesOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetSummarizedSignalStrengthForZWaveDevicesOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get SignalInfoList value
     * @return \CustomerManagement\ArrayType\ArrayOfDeviceSignalInfo|null
     */
    public function getSignalInfoList()
    {
        return $this->SignalInfoList;
    }
    /**
     * Set SignalInfoList value
     * @param \CustomerManagement\ArrayType\ArrayOfDeviceSignalInfo $signalInfoList
     * @return \CustomerManagement\StructType\GetSummarizedSignalStrengthForZWaveDevicesOutput
     */
    public function setSignalInfoList(\CustomerManagement\ArrayType\ArrayOfDeviceSignalInfo $signalInfoList = null)
    {
        $this->SignalInfoList = $signalInfoList;
        return $this;
    }
}
