<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNotificationSubscription ArrayType
 * @subpackage Arrays
 */
class ArrayOfNotificationSubscription extends AbstractStructArrayBase
{
    /**
     * The NotificationSubscription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\NotificationSubscription[]
     */
    public $NotificationSubscription;
    /**
     * Constructor method for ArrayOfNotificationSubscription
     * @uses ArrayOfNotificationSubscription::setNotificationSubscription()
     * @param \CustomerManagement\StructType\NotificationSubscription[] $notificationSubscription
     */
    public function __construct(array $notificationSubscription = array())
    {
        $this
            ->setNotificationSubscription($notificationSubscription);
    }
    /**
     * Get NotificationSubscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\NotificationSubscription[]|null
     */
    public function getNotificationSubscription()
    {
        return isset($this->NotificationSubscription) ? $this->NotificationSubscription : null;
    }
    /**
     * This method is responsible for validating the values passed to the setNotificationSubscription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotificationSubscription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotificationSubscriptionForArrayConstraintsFromSetNotificationSubscription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfNotificationSubscriptionNotificationSubscriptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfNotificationSubscriptionNotificationSubscriptionItem instanceof \CustomerManagement\StructType\NotificationSubscription) {
                $invalidValues[] = is_object($arrayOfNotificationSubscriptionNotificationSubscriptionItem) ? get_class($arrayOfNotificationSubscriptionNotificationSubscriptionItem) : sprintf('%s(%s)', gettype($arrayOfNotificationSubscriptionNotificationSubscriptionItem), var_export($arrayOfNotificationSubscriptionNotificationSubscriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NotificationSubscription property can only contain items of type \CustomerManagement\StructType\NotificationSubscription, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NotificationSubscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\NotificationSubscription[] $notificationSubscription
     * @return \CustomerManagement\ArrayType\ArrayOfNotificationSubscription
     */
    public function setNotificationSubscription(array $notificationSubscription = array())
    {
        // validation for constraint: array
        if ('' !== ($notificationSubscriptionArrayErrorMessage = self::validateNotificationSubscriptionForArrayConstraintsFromSetNotificationSubscription($notificationSubscription))) {
            throw new \InvalidArgumentException($notificationSubscriptionArrayErrorMessage, __LINE__);
        }
        if (is_null($notificationSubscription) || (is_array($notificationSubscription) && empty($notificationSubscription))) {
            unset($this->NotificationSubscription);
        } else {
            $this->NotificationSubscription = $notificationSubscription;
        }
        return $this;
    }
    /**
     * Add item to NotificationSubscription value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\NotificationSubscription $item
     * @return \CustomerManagement\ArrayType\ArrayOfNotificationSubscription
     */
    public function addToNotificationSubscription(\CustomerManagement\StructType\NotificationSubscription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\NotificationSubscription) {
            throw new \InvalidArgumentException(sprintf('The NotificationSubscription property can only contain items of type \CustomerManagement\StructType\NotificationSubscription, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NotificationSubscription[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\NotificationSubscription|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\NotificationSubscription|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\NotificationSubscription|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\NotificationSubscription|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\NotificationSubscription|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NotificationSubscription
     */
    public function getAttributeName()
    {
        return 'NotificationSubscription';
    }
}
