<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetElectricityProvidersOutput StructType
 * @subpackage Structs
 */
class GetElectricityProvidersOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The ElectricityProviders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfElectricityProviderInfo
     */
    public $ElectricityProviders;
    /**
     * Constructor method for GetElectricityProvidersOutput
     * @uses GetElectricityProvidersOutput::setSuccess()
     * @uses GetElectricityProvidersOutput::setErrorMessage()
     * @uses GetElectricityProvidersOutput::setElectricityProviders()
     * @param bool $success
     * @param string $errorMessage
     * @param \CustomerManagement\ArrayType\ArrayOfElectricityProviderInfo $electricityProviders
     */
    public function __construct($success = null, $errorMessage = null, \CustomerManagement\ArrayType\ArrayOfElectricityProviderInfo $electricityProviders = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorMessage($errorMessage)
            ->setElectricityProviders($electricityProviders);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetElectricityProvidersOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetElectricityProvidersOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get ElectricityProviders value
     * @return \CustomerManagement\ArrayType\ArrayOfElectricityProviderInfo|null
     */
    public function getElectricityProviders()
    {
        return $this->ElectricityProviders;
    }
    /**
     * Set ElectricityProviders value
     * @param \CustomerManagement\ArrayType\ArrayOfElectricityProviderInfo $electricityProviders
     * @return \CustomerManagement\StructType\GetElectricityProvidersOutput
     */
    public function setElectricityProviders(\CustomerManagement\ArrayType\ArrayOfElectricityProviderInfo $electricityProviders = null)
    {
        $this->ElectricityProviders = $electricityProviders;
        return $this;
    }
}
