<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfElectricityProviderInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfElectricityProviderInfo extends AbstractStructArrayBase
{
    /**
     * The ElectricityProviderInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\ElectricityProviderInfo[]
     */
    public $ElectricityProviderInfo;
    /**
     * Constructor method for ArrayOfElectricityProviderInfo
     * @uses ArrayOfElectricityProviderInfo::setElectricityProviderInfo()
     * @param \CustomerManagement\StructType\ElectricityProviderInfo[] $electricityProviderInfo
     */
    public function __construct(array $electricityProviderInfo = array())
    {
        $this
            ->setElectricityProviderInfo($electricityProviderInfo);
    }
    /**
     * Get ElectricityProviderInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\ElectricityProviderInfo[]|null
     */
    public function getElectricityProviderInfo()
    {
        return isset($this->ElectricityProviderInfo) ? $this->ElectricityProviderInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setElectricityProviderInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setElectricityProviderInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateElectricityProviderInfoForArrayConstraintsFromSetElectricityProviderInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfElectricityProviderInfoElectricityProviderInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfElectricityProviderInfoElectricityProviderInfoItem instanceof \CustomerManagement\StructType\ElectricityProviderInfo) {
                $invalidValues[] = is_object($arrayOfElectricityProviderInfoElectricityProviderInfoItem) ? get_class($arrayOfElectricityProviderInfoElectricityProviderInfoItem) : sprintf('%s(%s)', gettype($arrayOfElectricityProviderInfoElectricityProviderInfoItem), var_export($arrayOfElectricityProviderInfoElectricityProviderInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ElectricityProviderInfo property can only contain items of type \CustomerManagement\StructType\ElectricityProviderInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ElectricityProviderInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\ElectricityProviderInfo[] $electricityProviderInfo
     * @return \CustomerManagement\ArrayType\ArrayOfElectricityProviderInfo
     */
    public function setElectricityProviderInfo(array $electricityProviderInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($electricityProviderInfoArrayErrorMessage = self::validateElectricityProviderInfoForArrayConstraintsFromSetElectricityProviderInfo($electricityProviderInfo))) {
            throw new \InvalidArgumentException($electricityProviderInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($electricityProviderInfo) || (is_array($electricityProviderInfo) && empty($electricityProviderInfo))) {
            unset($this->ElectricityProviderInfo);
        } else {
            $this->ElectricityProviderInfo = $electricityProviderInfo;
        }
        return $this;
    }
    /**
     * Add item to ElectricityProviderInfo value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\ElectricityProviderInfo $item
     * @return \CustomerManagement\ArrayType\ArrayOfElectricityProviderInfo
     */
    public function addToElectricityProviderInfo(\CustomerManagement\StructType\ElectricityProviderInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\ElectricityProviderInfo) {
            throw new \InvalidArgumentException(sprintf('The ElectricityProviderInfo property can only contain items of type \CustomerManagement\StructType\ElectricityProviderInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ElectricityProviderInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\ElectricityProviderInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\ElectricityProviderInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\ElectricityProviderInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\ElectricityProviderInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\ElectricityProviderInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ElectricityProviderInfo
     */
    public function getAttributeName()
    {
        return 'ElectricityProviderInfo';
    }
}
