<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAddOnHistoryItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfAddOnHistoryItem extends AbstractStructArrayBase
{
    /**
     * The AddOnHistoryItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\AddOnHistoryItem[]
     */
    public $AddOnHistoryItem;
    /**
     * Constructor method for ArrayOfAddOnHistoryItem
     * @uses ArrayOfAddOnHistoryItem::setAddOnHistoryItem()
     * @param \CustomerManagement\StructType\AddOnHistoryItem[] $addOnHistoryItem
     */
    public function __construct(array $addOnHistoryItem = array())
    {
        $this
            ->setAddOnHistoryItem($addOnHistoryItem);
    }
    /**
     * Get AddOnHistoryItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\AddOnHistoryItem[]|null
     */
    public function getAddOnHistoryItem()
    {
        return isset($this->AddOnHistoryItem) ? $this->AddOnHistoryItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAddOnHistoryItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddOnHistoryItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddOnHistoryItemForArrayConstraintsFromSetAddOnHistoryItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAddOnHistoryItemAddOnHistoryItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfAddOnHistoryItemAddOnHistoryItemItem instanceof \CustomerManagement\StructType\AddOnHistoryItem) {
                $invalidValues[] = is_object($arrayOfAddOnHistoryItemAddOnHistoryItemItem) ? get_class($arrayOfAddOnHistoryItemAddOnHistoryItemItem) : sprintf('%s(%s)', gettype($arrayOfAddOnHistoryItemAddOnHistoryItemItem), var_export($arrayOfAddOnHistoryItemAddOnHistoryItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddOnHistoryItem property can only contain items of type \CustomerManagement\StructType\AddOnHistoryItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddOnHistoryItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\AddOnHistoryItem[] $addOnHistoryItem
     * @return \CustomerManagement\ArrayType\ArrayOfAddOnHistoryItem
     */
    public function setAddOnHistoryItem(array $addOnHistoryItem = array())
    {
        // validation for constraint: array
        if ('' !== ($addOnHistoryItemArrayErrorMessage = self::validateAddOnHistoryItemForArrayConstraintsFromSetAddOnHistoryItem($addOnHistoryItem))) {
            throw new \InvalidArgumentException($addOnHistoryItemArrayErrorMessage, __LINE__);
        }
        if (is_null($addOnHistoryItem) || (is_array($addOnHistoryItem) && empty($addOnHistoryItem))) {
            unset($this->AddOnHistoryItem);
        } else {
            $this->AddOnHistoryItem = $addOnHistoryItem;
        }
        return $this;
    }
    /**
     * Add item to AddOnHistoryItem value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\AddOnHistoryItem $item
     * @return \CustomerManagement\ArrayType\ArrayOfAddOnHistoryItem
     */
    public function addToAddOnHistoryItem(\CustomerManagement\StructType\AddOnHistoryItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\AddOnHistoryItem) {
            throw new \InvalidArgumentException(sprintf('The AddOnHistoryItem property can only contain items of type \CustomerManagement\StructType\AddOnHistoryItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddOnHistoryItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\AddOnHistoryItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\AddOnHistoryItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\AddOnHistoryItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\AddOnHistoryItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\AddOnHistoryItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AddOnHistoryItem
     */
    public function getAttributeName()
    {
        return 'AddOnHistoryItem';
    }
}
