<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetScheduledAppointmentOutputV2 StructType
 * @subpackage Structs
 */
class GetScheduledAppointmentOutputV2 extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The Appointment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public $Appointment;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for GetScheduledAppointmentOutputV2
     * @uses GetScheduledAppointmentOutputV2::setSuccess()
     * @uses GetScheduledAppointmentOutputV2::setAppointment()
     * @uses GetScheduledAppointmentOutputV2::setErrorMessage()
     * @param bool $success
     * @param \CustomerManagement\StructType\ScheduledServiceDateInfoV2 $appointment
     * @param string $errorMessage
     */
    public function __construct($success = null, \CustomerManagement\StructType\ScheduledServiceDateInfoV2 $appointment = null, $errorMessage = null)
    {
        $this
            ->setSuccess($success)
            ->setAppointment($appointment)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetScheduledAppointmentOutputV2
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get Appointment value
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2|null
     */
    public function getAppointment()
    {
        return $this->Appointment;
    }
    /**
     * Set Appointment value
     * @param \CustomerManagement\StructType\ScheduledServiceDateInfoV2 $appointment
     * @return \CustomerManagement\StructType\GetScheduledAppointmentOutputV2
     */
    public function setAppointment(\CustomerManagement\StructType\ScheduledServiceDateInfoV2 $appointment = null)
    {
        $this->Appointment = $appointment;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetScheduledAppointmentOutputV2
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
}
