<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Update2GigSensorGroupInput StructType
 * @subpackage Structs
 */
class Update2GigSensorGroupInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The SensorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SensorId;
    /**
     * The PanelGroupId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PanelGroupId;
    /**
     * The EquipmentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EquipmentType;
    /**
     * The SensorLoop
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SensorLoop;
    /**
     * Constructor method for Update2GigSensorGroupInput
     * @uses Update2GigSensorGroupInput::setCustomerId()
     * @uses Update2GigSensorGroupInput::setSensorId()
     * @uses Update2GigSensorGroupInput::setPanelGroupId()
     * @uses Update2GigSensorGroupInput::setEquipmentType()
     * @uses Update2GigSensorGroupInput::setSensorLoop()
     * @param int $customerId
     * @param int $sensorId
     * @param int $panelGroupId
     * @param int $equipmentType
     * @param int $sensorLoop
     */
    public function __construct($customerId = null, $sensorId = null, $panelGroupId = null, $equipmentType = null, $sensorLoop = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setSensorId($sensorId)
            ->setPanelGroupId($panelGroupId)
            ->setEquipmentType($equipmentType)
            ->setSensorLoop($sensorLoop);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\Update2GigSensorGroupInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SensorId value
     * @return int
     */
    public function getSensorId()
    {
        return $this->SensorId;
    }
    /**
     * Set SensorId value
     * @param int $sensorId
     * @return \CustomerManagement\StructType\Update2GigSensorGroupInput
     */
    public function setSensorId($sensorId = null)
    {
        // validation for constraint: int
        if (!is_null($sensorId) && !(is_int($sensorId) || ctype_digit($sensorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sensorId, true), gettype($sensorId)), __LINE__);
        }
        $this->SensorId = $sensorId;
        return $this;
    }
    /**
     * Get PanelGroupId value
     * @return int
     */
    public function getPanelGroupId()
    {
        return $this->PanelGroupId;
    }
    /**
     * Set PanelGroupId value
     * @param int $panelGroupId
     * @return \CustomerManagement\StructType\Update2GigSensorGroupInput
     */
    public function setPanelGroupId($panelGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($panelGroupId) && !(is_int($panelGroupId) || ctype_digit($panelGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($panelGroupId, true), gettype($panelGroupId)), __LINE__);
        }
        $this->PanelGroupId = $panelGroupId;
        return $this;
    }
    /**
     * Get EquipmentType value
     * @return int
     */
    public function getEquipmentType()
    {
        return $this->EquipmentType;
    }
    /**
     * Set EquipmentType value
     * @param int $equipmentType
     * @return \CustomerManagement\StructType\Update2GigSensorGroupInput
     */
    public function setEquipmentType($equipmentType = null)
    {
        // validation for constraint: int
        if (!is_null($equipmentType) && !(is_int($equipmentType) || ctype_digit($equipmentType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($equipmentType, true), gettype($equipmentType)), __LINE__);
        }
        $this->EquipmentType = $equipmentType;
        return $this;
    }
    /**
     * Get SensorLoop value
     * @return int
     */
    public function getSensorLoop()
    {
        return $this->SensorLoop;
    }
    /**
     * Set SensorLoop value
     * @param int $sensorLoop
     * @return \CustomerManagement\StructType\Update2GigSensorGroupInput
     */
    public function setSensorLoop($sensorLoop = null)
    {
        // validation for constraint: int
        if (!is_null($sensorLoop) && !(is_int($sensorLoop) || ctype_digit($sensorLoop))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sensorLoop, true), gettype($sensorLoop)), __LINE__);
        }
        $this->SensorLoop = $sensorLoop;
        return $this;
    }
}
