<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerInfo StructType
 * @subpackage Structs
 */
class CustomerInfo extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The IsTerminated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTerminated;
    /**
     * The IsDemo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDemo;
    /**
     * The JoinDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $JoinDate;
    /**
     * The TermDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TermDate;
    /**
     * The PanelVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PanelVersion;
    /**
     * The DealerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DealerId;
    /**
     * The SubDealerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SubDealerId;
    /**
     * The PanelNotRespondingStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PanelNotRespondingStatus;
    /**
     * The Culture
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Culture;
    /**
     * The PropertyType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PropertyType;
    /**
     * The InstallType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InstallType;
    /**
     * The PackageTemplateId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PackageTemplateId;
    /**
     * The ZWaveTask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ZWaveTask;
    /**
     * The ReadyDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReadyDateUtc;
    /**
     * The CustomerType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CustomerType;
    /**
     * The DealerCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DealerCustomerId;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The PrimaryEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryEmail;
    /**
     * The PrimaryPhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryPhoneNumber;
    /**
     * The LoginName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginName;
    /**
     * The InstallAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\Address
     */
    public $InstallAddress;
    /**
     * The ModemInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\ModemInfo
     */
    public $ModemInfo;
    /**
     * The CentralStationInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\CentralStationInfo
     */
    public $CentralStationInfo;
    /**
     * The ServicePlanInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\ServicePlanInfo
     */
    public $ServicePlanInfo;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyName;
    /**
     * The DetailedPanelVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DetailedPanelVersion;
    /**
     * The UnitDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitDescription;
    /**
     * The installerLogin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $installerLogin;
    /**
     * The salesRepLogin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $salesRepLogin;
    /**
     * The CustomerAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\Address
     */
    public $CustomerAddress;
    /**
     * The SEMFirmwareVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SEMFirmwareVersion;
    /**
     * Constructor method for CustomerInfo
     * @uses CustomerInfo::setCustomerId()
     * @uses CustomerInfo::setIsTerminated()
     * @uses CustomerInfo::setIsDemo()
     * @uses CustomerInfo::setJoinDate()
     * @uses CustomerInfo::setTermDate()
     * @uses CustomerInfo::setPanelVersion()
     * @uses CustomerInfo::setDealerId()
     * @uses CustomerInfo::setSubDealerId()
     * @uses CustomerInfo::setPanelNotRespondingStatus()
     * @uses CustomerInfo::setCulture()
     * @uses CustomerInfo::setPropertyType()
     * @uses CustomerInfo::setInstallType()
     * @uses CustomerInfo::setPackageTemplateId()
     * @uses CustomerInfo::setZWaveTask()
     * @uses CustomerInfo::setReadyDateUtc()
     * @uses CustomerInfo::setCustomerType()
     * @uses CustomerInfo::setDealerCustomerId()
     * @uses CustomerInfo::setFirstName()
     * @uses CustomerInfo::setLastName()
     * @uses CustomerInfo::setPrimaryEmail()
     * @uses CustomerInfo::setPrimaryPhoneNumber()
     * @uses CustomerInfo::setLoginName()
     * @uses CustomerInfo::setInstallAddress()
     * @uses CustomerInfo::setModemInfo()
     * @uses CustomerInfo::setCentralStationInfo()
     * @uses CustomerInfo::setServicePlanInfo()
     * @uses CustomerInfo::setCompanyName()
     * @uses CustomerInfo::setDetailedPanelVersion()
     * @uses CustomerInfo::setUnitDescription()
     * @uses CustomerInfo::setInstallerLogin()
     * @uses CustomerInfo::setSalesRepLogin()
     * @uses CustomerInfo::setCustomerAddress()
     * @uses CustomerInfo::setSEMFirmwareVersion()
     * @param int $customerId
     * @param bool $isTerminated
     * @param bool $isDemo
     * @param string $joinDate
     * @param string $termDate
     * @param string $panelVersion
     * @param int $dealerId
     * @param int $subDealerId
     * @param string $panelNotRespondingStatus
     * @param string $culture
     * @param string $propertyType
     * @param string $installType
     * @param int $packageTemplateId
     * @param int $zWaveTask
     * @param string $readyDateUtc
     * @param string $customerType
     * @param string $dealerCustomerId
     * @param string $firstName
     * @param string $lastName
     * @param string $primaryEmail
     * @param string $primaryPhoneNumber
     * @param string $loginName
     * @param \CustomerManagement\StructType\Address $installAddress
     * @param \CustomerManagement\StructType\ModemInfo $modemInfo
     * @param \CustomerManagement\StructType\CentralStationInfo $centralStationInfo
     * @param \CustomerManagement\StructType\ServicePlanInfo $servicePlanInfo
     * @param string $companyName
     * @param string $detailedPanelVersion
     * @param string $unitDescription
     * @param string $installerLogin
     * @param string $salesRepLogin
     * @param \CustomerManagement\StructType\Address $customerAddress
     * @param string $sEMFirmwareVersion
     */
    public function __construct($customerId = null, $isTerminated = null, $isDemo = null, $joinDate = null, $termDate = null, $panelVersion = null, $dealerId = null, $subDealerId = null, $panelNotRespondingStatus = null, $culture = null, $propertyType = null, $installType = null, $packageTemplateId = null, $zWaveTask = null, $readyDateUtc = null, $customerType = null, $dealerCustomerId = null, $firstName = null, $lastName = null, $primaryEmail = null, $primaryPhoneNumber = null, $loginName = null, \CustomerManagement\StructType\Address $installAddress = null, \CustomerManagement\StructType\ModemInfo $modemInfo = null, \CustomerManagement\StructType\CentralStationInfo $centralStationInfo = null, \CustomerManagement\StructType\ServicePlanInfo $servicePlanInfo = null, $companyName = null, $detailedPanelVersion = null, $unitDescription = null, $installerLogin = null, $salesRepLogin = null, \CustomerManagement\StructType\Address $customerAddress = null, $sEMFirmwareVersion = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setIsTerminated($isTerminated)
            ->setIsDemo($isDemo)
            ->setJoinDate($joinDate)
            ->setTermDate($termDate)
            ->setPanelVersion($panelVersion)
            ->setDealerId($dealerId)
            ->setSubDealerId($subDealerId)
            ->setPanelNotRespondingStatus($panelNotRespondingStatus)
            ->setCulture($culture)
            ->setPropertyType($propertyType)
            ->setInstallType($installType)
            ->setPackageTemplateId($packageTemplateId)
            ->setZWaveTask($zWaveTask)
            ->setReadyDateUtc($readyDateUtc)
            ->setCustomerType($customerType)
            ->setDealerCustomerId($dealerCustomerId)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setPrimaryEmail($primaryEmail)
            ->setPrimaryPhoneNumber($primaryPhoneNumber)
            ->setLoginName($loginName)
            ->setInstallAddress($installAddress)
            ->setModemInfo($modemInfo)
            ->setCentralStationInfo($centralStationInfo)
            ->setServicePlanInfo($servicePlanInfo)
            ->setCompanyName($companyName)
            ->setDetailedPanelVersion($detailedPanelVersion)
            ->setUnitDescription($unitDescription)
            ->setInstallerLogin($installerLogin)
            ->setSalesRepLogin($salesRepLogin)
            ->setCustomerAddress($customerAddress)
            ->setSEMFirmwareVersion($sEMFirmwareVersion);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get IsTerminated value
     * @return bool
     */
    public function getIsTerminated()
    {
        return $this->IsTerminated;
    }
    /**
     * Set IsTerminated value
     * @param bool $isTerminated
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setIsTerminated($isTerminated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTerminated) && !is_bool($isTerminated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTerminated, true), gettype($isTerminated)), __LINE__);
        }
        $this->IsTerminated = $isTerminated;
        return $this;
    }
    /**
     * Get IsDemo value
     * @return bool
     */
    public function getIsDemo()
    {
        return $this->IsDemo;
    }
    /**
     * Set IsDemo value
     * @param bool $isDemo
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setIsDemo($isDemo = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDemo) && !is_bool($isDemo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDemo, true), gettype($isDemo)), __LINE__);
        }
        $this->IsDemo = $isDemo;
        return $this;
    }
    /**
     * Get JoinDate value
     * @return string
     */
    public function getJoinDate()
    {
        return $this->JoinDate;
    }
    /**
     * Set JoinDate value
     * @param string $joinDate
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setJoinDate($joinDate = null)
    {
        // validation for constraint: string
        if (!is_null($joinDate) && !is_string($joinDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($joinDate, true), gettype($joinDate)), __LINE__);
        }
        $this->JoinDate = $joinDate;
        return $this;
    }
    /**
     * Get TermDate value
     * @return string
     */
    public function getTermDate()
    {
        return $this->TermDate;
    }
    /**
     * Set TermDate value
     * @param string $termDate
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setTermDate($termDate = null)
    {
        // validation for constraint: string
        if (!is_null($termDate) && !is_string($termDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($termDate, true), gettype($termDate)), __LINE__);
        }
        $this->TermDate = $termDate;
        return $this;
    }
    /**
     * Get PanelVersion value
     * @return string
     */
    public function getPanelVersion()
    {
        return $this->PanelVersion;
    }
    /**
     * Set PanelVersion value
     * @uses \CustomerManagement\EnumType\PanelVersionEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\PanelVersionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $panelVersion
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setPanelVersion($panelVersion = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\PanelVersionEnum::valueIsValid($panelVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\PanelVersionEnum', is_array($panelVersion) ? implode(', ', $panelVersion) : var_export($panelVersion, true), implode(', ', \CustomerManagement\EnumType\PanelVersionEnum::getValidValues())), __LINE__);
        }
        $this->PanelVersion = $panelVersion;
        return $this;
    }
    /**
     * Get DealerId value
     * @return int
     */
    public function getDealerId()
    {
        return $this->DealerId;
    }
    /**
     * Set DealerId value
     * @param int $dealerId
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setDealerId($dealerId = null)
    {
        // validation for constraint: int
        if (!is_null($dealerId) && !(is_int($dealerId) || ctype_digit($dealerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dealerId, true), gettype($dealerId)), __LINE__);
        }
        $this->DealerId = $dealerId;
        return $this;
    }
    /**
     * Get SubDealerId value
     * @return int
     */
    public function getSubDealerId()
    {
        return $this->SubDealerId;
    }
    /**
     * Set SubDealerId value
     * @param int $subDealerId
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setSubDealerId($subDealerId = null)
    {
        // validation for constraint: int
        if (!is_null($subDealerId) && !(is_int($subDealerId) || ctype_digit($subDealerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($subDealerId, true), gettype($subDealerId)), __LINE__);
        }
        $this->SubDealerId = $subDealerId;
        return $this;
    }
    /**
     * Get PanelNotRespondingStatus value
     * @return string
     */
    public function getPanelNotRespondingStatus()
    {
        return $this->PanelNotRespondingStatus;
    }
    /**
     * Set PanelNotRespondingStatus value
     * @uses \CustomerManagement\EnumType\PanelNotRespondingStatusEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\PanelNotRespondingStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $panelNotRespondingStatus
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setPanelNotRespondingStatus($panelNotRespondingStatus = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\PanelNotRespondingStatusEnum::valueIsValid($panelNotRespondingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\PanelNotRespondingStatusEnum', is_array($panelNotRespondingStatus) ? implode(', ', $panelNotRespondingStatus) : var_export($panelNotRespondingStatus, true), implode(', ', \CustomerManagement\EnumType\PanelNotRespondingStatusEnum::getValidValues())), __LINE__);
        }
        $this->PanelNotRespondingStatus = $panelNotRespondingStatus;
        return $this;
    }
    /**
     * Get Culture value
     * @return string
     */
    public function getCulture()
    {
        return $this->Culture;
    }
    /**
     * Set Culture value
     * @uses \CustomerManagement\EnumType\CultureEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CultureEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $culture
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setCulture($culture = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CultureEnum::valueIsValid($culture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\CultureEnum', is_array($culture) ? implode(', ', $culture) : var_export($culture, true), implode(', ', \CustomerManagement\EnumType\CultureEnum::getValidValues())), __LINE__);
        }
        $this->Culture = $culture;
        return $this;
    }
    /**
     * Get PropertyType value
     * @return string
     */
    public function getPropertyType()
    {
        return $this->PropertyType;
    }
    /**
     * Set PropertyType value
     * @uses \CustomerManagement\EnumType\PropertyTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\PropertyTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $propertyType
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setPropertyType($propertyType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\PropertyTypeEnum::valueIsValid($propertyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\PropertyTypeEnum', is_array($propertyType) ? implode(', ', $propertyType) : var_export($propertyType, true), implode(', ', \CustomerManagement\EnumType\PropertyTypeEnum::getValidValues())), __LINE__);
        }
        $this->PropertyType = $propertyType;
        return $this;
    }
    /**
     * Get InstallType value
     * @return string
     */
    public function getInstallType()
    {
        return $this->InstallType;
    }
    /**
     * Set InstallType value
     * @uses \CustomerManagement\EnumType\CustomerInstallTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CustomerInstallTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installType
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setInstallType($installType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CustomerInstallTypeEnum::valueIsValid($installType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\CustomerInstallTypeEnum', is_array($installType) ? implode(', ', $installType) : var_export($installType, true), implode(', ', \CustomerManagement\EnumType\CustomerInstallTypeEnum::getValidValues())), __LINE__);
        }
        $this->InstallType = $installType;
        return $this;
    }
    /**
     * Get PackageTemplateId value
     * @return int
     */
    public function getPackageTemplateId()
    {
        return $this->PackageTemplateId;
    }
    /**
     * Set PackageTemplateId value
     * @param int $packageTemplateId
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setPackageTemplateId($packageTemplateId = null)
    {
        // validation for constraint: int
        if (!is_null($packageTemplateId) && !(is_int($packageTemplateId) || ctype_digit($packageTemplateId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageTemplateId, true), gettype($packageTemplateId)), __LINE__);
        }
        $this->PackageTemplateId = $packageTemplateId;
        return $this;
    }
    /**
     * Get ZWaveTask value
     * @return int
     */
    public function getZWaveTask()
    {
        return $this->ZWaveTask;
    }
    /**
     * Set ZWaveTask value
     * @param int $zWaveTask
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setZWaveTask($zWaveTask = null)
    {
        // validation for constraint: int
        if (!is_null($zWaveTask) && !(is_int($zWaveTask) || ctype_digit($zWaveTask))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zWaveTask, true), gettype($zWaveTask)), __LINE__);
        }
        $this->ZWaveTask = $zWaveTask;
        return $this;
    }
    /**
     * Get ReadyDateUtc value
     * @return string
     */
    public function getReadyDateUtc()
    {
        return $this->ReadyDateUtc;
    }
    /**
     * Set ReadyDateUtc value
     * @param string $readyDateUtc
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setReadyDateUtc($readyDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($readyDateUtc) && !is_string($readyDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($readyDateUtc, true), gettype($readyDateUtc)), __LINE__);
        }
        $this->ReadyDateUtc = $readyDateUtc;
        return $this;
    }
    /**
     * Get CustomerType value
     * @return string
     */
    public function getCustomerType()
    {
        return $this->CustomerType;
    }
    /**
     * Set CustomerType value
     * @uses \CustomerManagement\EnumType\CustomerTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CustomerTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $customerType
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setCustomerType($customerType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CustomerTypeEnum::valueIsValid($customerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\CustomerTypeEnum', is_array($customerType) ? implode(', ', $customerType) : var_export($customerType, true), implode(', ', \CustomerManagement\EnumType\CustomerTypeEnum::getValidValues())), __LINE__);
        }
        $this->CustomerType = $customerType;
        return $this;
    }
    /**
     * Get DealerCustomerId value
     * @return string|null
     */
    public function getDealerCustomerId()
    {
        return $this->DealerCustomerId;
    }
    /**
     * Set DealerCustomerId value
     * @param string $dealerCustomerId
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setDealerCustomerId($dealerCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($dealerCustomerId) && !is_string($dealerCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dealerCustomerId, true), gettype($dealerCustomerId)), __LINE__);
        }
        $this->DealerCustomerId = $dealerCustomerId;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get PrimaryEmail value
     * @return string|null
     */
    public function getPrimaryEmail()
    {
        return $this->PrimaryEmail;
    }
    /**
     * Set PrimaryEmail value
     * @param string $primaryEmail
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setPrimaryEmail($primaryEmail = null)
    {
        // validation for constraint: string
        if (!is_null($primaryEmail) && !is_string($primaryEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryEmail, true), gettype($primaryEmail)), __LINE__);
        }
        $this->PrimaryEmail = $primaryEmail;
        return $this;
    }
    /**
     * Get PrimaryPhoneNumber value
     * @return string|null
     */
    public function getPrimaryPhoneNumber()
    {
        return $this->PrimaryPhoneNumber;
    }
    /**
     * Set PrimaryPhoneNumber value
     * @param string $primaryPhoneNumber
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setPrimaryPhoneNumber($primaryPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($primaryPhoneNumber) && !is_string($primaryPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryPhoneNumber, true), gettype($primaryPhoneNumber)), __LINE__);
        }
        $this->PrimaryPhoneNumber = $primaryPhoneNumber;
        return $this;
    }
    /**
     * Get LoginName value
     * @return string|null
     */
    public function getLoginName()
    {
        return $this->LoginName;
    }
    /**
     * Set LoginName value
     * @param string $loginName
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginName, true), gettype($loginName)), __LINE__);
        }
        $this->LoginName = $loginName;
        return $this;
    }
    /**
     * Get InstallAddress value
     * @return \CustomerManagement\StructType\Address|null
     */
    public function getInstallAddress()
    {
        return $this->InstallAddress;
    }
    /**
     * Set InstallAddress value
     * @param \CustomerManagement\StructType\Address $installAddress
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setInstallAddress(\CustomerManagement\StructType\Address $installAddress = null)
    {
        $this->InstallAddress = $installAddress;
        return $this;
    }
    /**
     * Get ModemInfo value
     * @return \CustomerManagement\StructType\ModemInfo|null
     */
    public function getModemInfo()
    {
        return $this->ModemInfo;
    }
    /**
     * Set ModemInfo value
     * @param \CustomerManagement\StructType\ModemInfo $modemInfo
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setModemInfo(\CustomerManagement\StructType\ModemInfo $modemInfo = null)
    {
        $this->ModemInfo = $modemInfo;
        return $this;
    }
    /**
     * Get CentralStationInfo value
     * @return \CustomerManagement\StructType\CentralStationInfo|null
     */
    public function getCentralStationInfo()
    {
        return $this->CentralStationInfo;
    }
    /**
     * Set CentralStationInfo value
     * @param \CustomerManagement\StructType\CentralStationInfo $centralStationInfo
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setCentralStationInfo(\CustomerManagement\StructType\CentralStationInfo $centralStationInfo = null)
    {
        $this->CentralStationInfo = $centralStationInfo;
        return $this;
    }
    /**
     * Get ServicePlanInfo value
     * @return \CustomerManagement\StructType\ServicePlanInfo|null
     */
    public function getServicePlanInfo()
    {
        return $this->ServicePlanInfo;
    }
    /**
     * Set ServicePlanInfo value
     * @param \CustomerManagement\StructType\ServicePlanInfo $servicePlanInfo
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setServicePlanInfo(\CustomerManagement\StructType\ServicePlanInfo $servicePlanInfo = null)
    {
        $this->ServicePlanInfo = $servicePlanInfo;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get DetailedPanelVersion value
     * @return string|null
     */
    public function getDetailedPanelVersion()
    {
        return $this->DetailedPanelVersion;
    }
    /**
     * Set DetailedPanelVersion value
     * @param string $detailedPanelVersion
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setDetailedPanelVersion($detailedPanelVersion = null)
    {
        // validation for constraint: string
        if (!is_null($detailedPanelVersion) && !is_string($detailedPanelVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detailedPanelVersion, true), gettype($detailedPanelVersion)), __LINE__);
        }
        $this->DetailedPanelVersion = $detailedPanelVersion;
        return $this;
    }
    /**
     * Get UnitDescription value
     * @return string|null
     */
    public function getUnitDescription()
    {
        return $this->UnitDescription;
    }
    /**
     * Set UnitDescription value
     * @param string $unitDescription
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setUnitDescription($unitDescription = null)
    {
        // validation for constraint: string
        if (!is_null($unitDescription) && !is_string($unitDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitDescription, true), gettype($unitDescription)), __LINE__);
        }
        $this->UnitDescription = $unitDescription;
        return $this;
    }
    /**
     * Get installerLogin value
     * @return string|null
     */
    public function getInstallerLogin()
    {
        return $this->installerLogin;
    }
    /**
     * Set installerLogin value
     * @param string $installerLogin
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setInstallerLogin($installerLogin = null)
    {
        // validation for constraint: string
        if (!is_null($installerLogin) && !is_string($installerLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installerLogin, true), gettype($installerLogin)), __LINE__);
        }
        $this->installerLogin = $installerLogin;
        return $this;
    }
    /**
     * Get salesRepLogin value
     * @return string|null
     */
    public function getSalesRepLogin()
    {
        return $this->salesRepLogin;
    }
    /**
     * Set salesRepLogin value
     * @param string $salesRepLogin
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setSalesRepLogin($salesRepLogin = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepLogin) && !is_string($salesRepLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepLogin, true), gettype($salesRepLogin)), __LINE__);
        }
        $this->salesRepLogin = $salesRepLogin;
        return $this;
    }
    /**
     * Get CustomerAddress value
     * @return \CustomerManagement\StructType\Address|null
     */
    public function getCustomerAddress()
    {
        return $this->CustomerAddress;
    }
    /**
     * Set CustomerAddress value
     * @param \CustomerManagement\StructType\Address $customerAddress
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setCustomerAddress(\CustomerManagement\StructType\Address $customerAddress = null)
    {
        $this->CustomerAddress = $customerAddress;
        return $this;
    }
    /**
     * Get SEMFirmwareVersion value
     * @return string|null
     */
    public function getSEMFirmwareVersion()
    {
        return $this->SEMFirmwareVersion;
    }
    /**
     * Set SEMFirmwareVersion value
     * @param string $sEMFirmwareVersion
     * @return \CustomerManagement\StructType\CustomerInfo
     */
    public function setSEMFirmwareVersion($sEMFirmwareVersion = null)
    {
        // validation for constraint: string
        if (!is_null($sEMFirmwareVersion) && !is_string($sEMFirmwareVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sEMFirmwareVersion, true), gettype($sEMFirmwareVersion)), __LINE__);
        }
        $this->SEMFirmwareVersion = $sEMFirmwareVersion;
        return $this;
    }
}
