<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateScheduledAppointmentInputV2 StructType
 * @subpackage Structs
 */
class CreateScheduledAppointmentInputV2 extends CreateScheduledAppointmentInput
{
    /**
     * The DateEndRangeUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateEndRangeUtc;
    /**
     * The IsVirtual
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsVirtual;
    /**
     * The EstimatedDurationMinutes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EstimatedDurationMinutes;
    /**
     * The IncludeRepInfoInEmails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IncludeRepInfoInEmails;
    /**
     * The AppointmentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum
     */
    public $AppointmentType;
    /**
     * The CustomerFacingInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerFacingInfo;
    /**
     * The MeetingLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeetingLocation;
    /**
     * Constructor method for CreateScheduledAppointmentInputV2
     * @uses CreateScheduledAppointmentInputV2::setDateEndRangeUtc()
     * @uses CreateScheduledAppointmentInputV2::setIsVirtual()
     * @uses CreateScheduledAppointmentInputV2::setEstimatedDurationMinutes()
     * @uses CreateScheduledAppointmentInputV2::setIncludeRepInfoInEmails()
     * @uses CreateScheduledAppointmentInputV2::setAppointmentType()
     * @uses CreateScheduledAppointmentInputV2::setCustomerFacingInfo()
     * @uses CreateScheduledAppointmentInputV2::setMeetingLocation()
     * @param string $dateEndRangeUtc
     * @param bool $isVirtual
     * @param int $estimatedDurationMinutes
     * @param bool $includeRepInfoInEmails
     * @param \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum $appointmentType
     * @param string $customerFacingInfo
     * @param string $meetingLocation
     */
    public function __construct($dateEndRangeUtc = null, $isVirtual = null, $estimatedDurationMinutes = null, $includeRepInfoInEmails = null, \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum $appointmentType = null, $customerFacingInfo = null, $meetingLocation = null)
    {
        $this
            ->setDateEndRangeUtc($dateEndRangeUtc)
            ->setIsVirtual($isVirtual)
            ->setEstimatedDurationMinutes($estimatedDurationMinutes)
            ->setIncludeRepInfoInEmails($includeRepInfoInEmails)
            ->setAppointmentType($appointmentType)
            ->setCustomerFacingInfo($customerFacingInfo)
            ->setMeetingLocation($meetingLocation);
    }
    /**
     * Get DateEndRangeUtc value
     * @return string
     */
    public function getDateEndRangeUtc()
    {
        return $this->DateEndRangeUtc;
    }
    /**
     * Set DateEndRangeUtc value
     * @param string $dateEndRangeUtc
     * @return \CustomerManagement\StructType\CreateScheduledAppointmentInputV2
     */
    public function setDateEndRangeUtc($dateEndRangeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($dateEndRangeUtc) && !is_string($dateEndRangeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateEndRangeUtc, true), gettype($dateEndRangeUtc)), __LINE__);
        }
        $this->DateEndRangeUtc = $dateEndRangeUtc;
        return $this;
    }
    /**
     * Get IsVirtual value
     * @return bool
     */
    public function getIsVirtual()
    {
        return $this->IsVirtual;
    }
    /**
     * Set IsVirtual value
     * @param bool $isVirtual
     * @return \CustomerManagement\StructType\CreateScheduledAppointmentInputV2
     */
    public function setIsVirtual($isVirtual = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVirtual) && !is_bool($isVirtual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVirtual, true), gettype($isVirtual)), __LINE__);
        }
        $this->IsVirtual = $isVirtual;
        return $this;
    }
    /**
     * Get EstimatedDurationMinutes value
     * @return int
     */
    public function getEstimatedDurationMinutes()
    {
        return $this->EstimatedDurationMinutes;
    }
    /**
     * Set EstimatedDurationMinutes value
     * @param int $estimatedDurationMinutes
     * @return \CustomerManagement\StructType\CreateScheduledAppointmentInputV2
     */
    public function setEstimatedDurationMinutes($estimatedDurationMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($estimatedDurationMinutes) && !(is_int($estimatedDurationMinutes) || ctype_digit($estimatedDurationMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($estimatedDurationMinutes, true), gettype($estimatedDurationMinutes)), __LINE__);
        }
        $this->EstimatedDurationMinutes = $estimatedDurationMinutes;
        return $this;
    }
    /**
     * Get IncludeRepInfoInEmails value
     * @return bool
     */
    public function getIncludeRepInfoInEmails()
    {
        return $this->IncludeRepInfoInEmails;
    }
    /**
     * Set IncludeRepInfoInEmails value
     * @param bool $includeRepInfoInEmails
     * @return \CustomerManagement\StructType\CreateScheduledAppointmentInputV2
     */
    public function setIncludeRepInfoInEmails($includeRepInfoInEmails = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeRepInfoInEmails) && !is_bool($includeRepInfoInEmails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeRepInfoInEmails, true), gettype($includeRepInfoInEmails)), __LINE__);
        }
        $this->IncludeRepInfoInEmails = $includeRepInfoInEmails;
        return $this;
    }
    /**
     * Get AppointmentType value
     * @return \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum|null
     */
    public function getAppointmentType()
    {
        return $this->AppointmentType;
    }
    /**
     * Set AppointmentType value
     * @param \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum $appointmentType
     * @return \CustomerManagement\StructType\CreateScheduledAppointmentInputV2
     */
    public function setAppointmentType(\CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum $appointmentType = null)
    {
        $this->AppointmentType = $appointmentType;
        return $this;
    }
    /**
     * Get CustomerFacingInfo value
     * @return string|null
     */
    public function getCustomerFacingInfo()
    {
        return $this->CustomerFacingInfo;
    }
    /**
     * Set CustomerFacingInfo value
     * @param string $customerFacingInfo
     * @return \CustomerManagement\StructType\CreateScheduledAppointmentInputV2
     */
    public function setCustomerFacingInfo($customerFacingInfo = null)
    {
        // validation for constraint: string
        if (!is_null($customerFacingInfo) && !is_string($customerFacingInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerFacingInfo, true), gettype($customerFacingInfo)), __LINE__);
        }
        $this->CustomerFacingInfo = $customerFacingInfo;
        return $this;
    }
    /**
     * Get MeetingLocation value
     * @return string|null
     */
    public function getMeetingLocation()
    {
        return $this->MeetingLocation;
    }
    /**
     * Set MeetingLocation value
     * @param string $meetingLocation
     * @return \CustomerManagement\StructType\CreateScheduledAppointmentInputV2
     */
    public function setMeetingLocation($meetingLocation = null)
    {
        // validation for constraint: string
        if (!is_null($meetingLocation) && !is_string($meetingLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meetingLocation, true), gettype($meetingLocation)), __LINE__);
        }
        $this->MeetingLocation = $meetingLocation;
        return $this;
    }
}
