<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeServicePlanValidationOnly StructType
 * @subpackage Structs
 */
class ChangeServicePlanValidationOnly extends AbstractStructBase
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The newPackageId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $newPackageId;
    /**
     * The addOnFeatures
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum
     */
    public $addOnFeatures;
    /**
     * Constructor method for ChangeServicePlanValidationOnly
     * @uses ChangeServicePlanValidationOnly::setCustomerId()
     * @uses ChangeServicePlanValidationOnly::setNewPackageId()
     * @uses ChangeServicePlanValidationOnly::setAddOnFeatures()
     * @param int $customerId
     * @param int $newPackageId
     * @param \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures
     */
    public function __construct($customerId = null, $newPackageId = null, \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setNewPackageId($newPackageId)
            ->setAddOnFeatures($addOnFeatures);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\ChangeServicePlanValidationOnly
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get newPackageId value
     * @return int
     */
    public function getNewPackageId()
    {
        return $this->newPackageId;
    }
    /**
     * Set newPackageId value
     * @param int $newPackageId
     * @return \CustomerManagement\StructType\ChangeServicePlanValidationOnly
     */
    public function setNewPackageId($newPackageId = null)
    {
        // validation for constraint: int
        if (!is_null($newPackageId) && !(is_int($newPackageId) || ctype_digit($newPackageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newPackageId, true), gettype($newPackageId)), __LINE__);
        }
        $this->newPackageId = $newPackageId;
        return $this;
    }
    /**
     * Get addOnFeatures value
     * @return \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum|null
     */
    public function getAddOnFeatures()
    {
        return $this->addOnFeatures;
    }
    /**
     * Set addOnFeatures value
     * @param \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures
     * @return \CustomerManagement\StructType\ChangeServicePlanValidationOnly
     */
    public function setAddOnFeatures(\CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures = null)
    {
        $this->addOnFeatures = $addOnFeatures;
        return $this;
    }
}
