<?php

namespace CustomerManagement\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for HistoryEventTypeEnum EnumType
 * @subpackage Enumerations
 */
class HistoryEventTypeEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'Closed'
     * @return string 'Closed'
     */
    const VALUE_CLOSED = 'Closed';
    /**
     * Constant for value 'Tamper'
     * @return string 'Tamper'
     */
    const VALUE_TAMPER = 'Tamper';
    /**
     * Constant for value 'Disarmed'
     * @return string 'Disarmed'
     */
    const VALUE_DISARMED = 'Disarmed';
    /**
     * Constant for value 'ArmedStay'
     * @return string 'ArmedStay'
     */
    const VALUE_ARMED_STAY = 'ArmedStay';
    /**
     * Constant for value 'ArmedAway'
     * @return string 'ArmedAway'
     */
    const VALUE_ARMED_AWAY = 'ArmedAway';
    /**
     * Constant for value 'Opened'
     * @return string 'Opened'
     */
    const VALUE_OPENED = 'Opened';
    /**
     * Constant for value 'OpenedClosed'
     * @return string 'OpenedClosed'
     */
    const VALUE_OPENED_CLOSED = 'OpenedClosed';
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_CLOSED
     * @uses self::VALUE_TAMPER
     * @uses self::VALUE_DISARMED
     * @uses self::VALUE_ARMED_STAY
     * @uses self::VALUE_ARMED_AWAY
     * @uses self::VALUE_OPENED
     * @uses self::VALUE_OPENED_CLOSED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_CLOSED,
            self::VALUE_TAMPER,
            self::VALUE_DISARMED,
            self::VALUE_ARMED_STAY,
            self::VALUE_ARMED_AWAY,
            self::VALUE_OPENED,
            self::VALUE_OPENED_CLOSED,
        );
    }
}
