<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditUserCodeInput StructType
 * @subpackage Structs
 */
class EditUserCodeInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The PanelUserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PanelUserId;
    /**
     * The VoiceAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $VoiceAccess;
    /**
     * The PartitionFlags
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PartitionFlags;
    /**
     * The UserFirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserFirstName;
    /**
     * The UserLastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserLastName;
    /**
     * The NewUserCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewUserCode;
    /**
     * The EnabledAccessPointDeviceIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfInt
     */
    public $EnabledAccessPointDeviceIds;
    /**
     * Constructor method for EditUserCodeInput
     * @uses EditUserCodeInput::setCustomerId()
     * @uses EditUserCodeInput::setPanelUserId()
     * @uses EditUserCodeInput::setVoiceAccess()
     * @uses EditUserCodeInput::setPartitionFlags()
     * @uses EditUserCodeInput::setUserFirstName()
     * @uses EditUserCodeInput::setUserLastName()
     * @uses EditUserCodeInput::setNewUserCode()
     * @uses EditUserCodeInput::setEnabledAccessPointDeviceIds()
     * @param int $customerId
     * @param int $panelUserId
     * @param bool $voiceAccess
     * @param int $partitionFlags
     * @param string $userFirstName
     * @param string $userLastName
     * @param string $newUserCode
     * @param \CustomerManagement\ArrayType\ArrayOfInt $enabledAccessPointDeviceIds
     */
    public function __construct($customerId = null, $panelUserId = null, $voiceAccess = null, $partitionFlags = null, $userFirstName = null, $userLastName = null, $newUserCode = null, \CustomerManagement\ArrayType\ArrayOfInt $enabledAccessPointDeviceIds = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setPanelUserId($panelUserId)
            ->setVoiceAccess($voiceAccess)
            ->setPartitionFlags($partitionFlags)
            ->setUserFirstName($userFirstName)
            ->setUserLastName($userLastName)
            ->setNewUserCode($newUserCode)
            ->setEnabledAccessPointDeviceIds($enabledAccessPointDeviceIds);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\EditUserCodeInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get PanelUserId value
     * @return int
     */
    public function getPanelUserId()
    {
        return $this->PanelUserId;
    }
    /**
     * Set PanelUserId value
     * @param int $panelUserId
     * @return \CustomerManagement\StructType\EditUserCodeInput
     */
    public function setPanelUserId($panelUserId = null)
    {
        // validation for constraint: int
        if (!is_null($panelUserId) && !(is_int($panelUserId) || ctype_digit($panelUserId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($panelUserId, true), gettype($panelUserId)), __LINE__);
        }
        $this->PanelUserId = $panelUserId;
        return $this;
    }
    /**
     * Get VoiceAccess value
     * @return bool
     */
    public function getVoiceAccess()
    {
        return $this->VoiceAccess;
    }
    /**
     * Set VoiceAccess value
     * @param bool $voiceAccess
     * @return \CustomerManagement\StructType\EditUserCodeInput
     */
    public function setVoiceAccess($voiceAccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($voiceAccess) && !is_bool($voiceAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($voiceAccess, true), gettype($voiceAccess)), __LINE__);
        }
        $this->VoiceAccess = $voiceAccess;
        return $this;
    }
    /**
     * Get PartitionFlags value
     * @return int
     */
    public function getPartitionFlags()
    {
        return $this->PartitionFlags;
    }
    /**
     * Set PartitionFlags value
     * @param int $partitionFlags
     * @return \CustomerManagement\StructType\EditUserCodeInput
     */
    public function setPartitionFlags($partitionFlags = null)
    {
        // validation for constraint: int
        if (!is_null($partitionFlags) && !(is_int($partitionFlags) || ctype_digit($partitionFlags))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($partitionFlags, true), gettype($partitionFlags)), __LINE__);
        }
        $this->PartitionFlags = $partitionFlags;
        return $this;
    }
    /**
     * Get UserFirstName value
     * @return string|null
     */
    public function getUserFirstName()
    {
        return $this->UserFirstName;
    }
    /**
     * Set UserFirstName value
     * @param string $userFirstName
     * @return \CustomerManagement\StructType\EditUserCodeInput
     */
    public function setUserFirstName($userFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($userFirstName) && !is_string($userFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userFirstName, true), gettype($userFirstName)), __LINE__);
        }
        $this->UserFirstName = $userFirstName;
        return $this;
    }
    /**
     * Get UserLastName value
     * @return string|null
     */
    public function getUserLastName()
    {
        return $this->UserLastName;
    }
    /**
     * Set UserLastName value
     * @param string $userLastName
     * @return \CustomerManagement\StructType\EditUserCodeInput
     */
    public function setUserLastName($userLastName = null)
    {
        // validation for constraint: string
        if (!is_null($userLastName) && !is_string($userLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userLastName, true), gettype($userLastName)), __LINE__);
        }
        $this->UserLastName = $userLastName;
        return $this;
    }
    /**
     * Get NewUserCode value
     * @return string|null
     */
    public function getNewUserCode()
    {
        return $this->NewUserCode;
    }
    /**
     * Set NewUserCode value
     * @param string $newUserCode
     * @return \CustomerManagement\StructType\EditUserCodeInput
     */
    public function setNewUserCode($newUserCode = null)
    {
        // validation for constraint: string
        if (!is_null($newUserCode) && !is_string($newUserCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newUserCode, true), gettype($newUserCode)), __LINE__);
        }
        $this->NewUserCode = $newUserCode;
        return $this;
    }
    /**
     * Get EnabledAccessPointDeviceIds value
     * @return \CustomerManagement\ArrayType\ArrayOfInt|null
     */
    public function getEnabledAccessPointDeviceIds()
    {
        return $this->EnabledAccessPointDeviceIds;
    }
    /**
     * Set EnabledAccessPointDeviceIds value
     * @param \CustomerManagement\ArrayType\ArrayOfInt $enabledAccessPointDeviceIds
     * @return \CustomerManagement\StructType\EditUserCodeInput
     */
    public function setEnabledAccessPointDeviceIds(\CustomerManagement\ArrayType\ArrayOfInt $enabledAccessPointDeviceIds = null)
    {
        $this->EnabledAccessPointDeviceIds = $enabledAccessPointDeviceIds;
        return $this;
    }
}
