<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerRiskScore StructType
 * @subpackage Structs
 */
class CustomerRiskScore extends AbstractStructBase
{
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The RiskScore
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $RiskScore;
    /**
     * Constructor method for CustomerRiskScore
     * @uses CustomerRiskScore::setCustomerID()
     * @uses CustomerRiskScore::setRiskScore()
     * @param int $customerID
     * @param float $riskScore
     */
    public function __construct($customerID = null, $riskScore = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setRiskScore($riskScore);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \CustomerManagement\StructType\CustomerRiskScore
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !(is_int($customerID) || ctype_digit($customerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get RiskScore value
     * @return float
     */
    public function getRiskScore()
    {
        return $this->RiskScore;
    }
    /**
     * Set RiskScore value
     * @param float $riskScore
     * @return \CustomerManagement\StructType\CustomerRiskScore
     */
    public function setRiskScore($riskScore = null)
    {
        // validation for constraint: float
        if (!is_null($riskScore) && !(is_float($riskScore) || is_numeric($riskScore))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($riskScore, true), gettype($riskScore)), __LINE__);
        }
        $this->RiskScore = $riskScore;
        return $this;
    }
}
