<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateSolarConnectionInput StructType
 * @subpackage Structs
 */
class CreateSolarConnectionInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The SolarProvider
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SolarProvider;
    /**
     * The ExpectedYearlyProduction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ExpectedYearlyProduction;
    /**
     * The ConnectionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConnectionId;
    /**
     * Constructor method for CreateSolarConnectionInput
     * @uses CreateSolarConnectionInput::setCustomerId()
     * @uses CreateSolarConnectionInput::setSolarProvider()
     * @uses CreateSolarConnectionInput::setExpectedYearlyProduction()
     * @uses CreateSolarConnectionInput::setConnectionId()
     * @param int $customerId
     * @param string $solarProvider
     * @param float $expectedYearlyProduction
     * @param string $connectionId
     */
    public function __construct($customerId = null, $solarProvider = null, $expectedYearlyProduction = null, $connectionId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setSolarProvider($solarProvider)
            ->setExpectedYearlyProduction($expectedYearlyProduction)
            ->setConnectionId($connectionId);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\CreateSolarConnectionInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SolarProvider value
     * @return string
     */
    public function getSolarProvider()
    {
        return $this->SolarProvider;
    }
    /**
     * Set SolarProvider value
     * @uses \CustomerManagement\EnumType\SolarProviderEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\SolarProviderEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $solarProvider
     * @return \CustomerManagement\StructType\CreateSolarConnectionInput
     */
    public function setSolarProvider($solarProvider = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\SolarProviderEnum::valueIsValid($solarProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\SolarProviderEnum', is_array($solarProvider) ? implode(', ', $solarProvider) : var_export($solarProvider, true), implode(', ', \CustomerManagement\EnumType\SolarProviderEnum::getValidValues())), __LINE__);
        }
        $this->SolarProvider = $solarProvider;
        return $this;
    }
    /**
     * Get ExpectedYearlyProduction value
     * @return float
     */
    public function getExpectedYearlyProduction()
    {
        return $this->ExpectedYearlyProduction;
    }
    /**
     * Set ExpectedYearlyProduction value
     * @param float $expectedYearlyProduction
     * @return \CustomerManagement\StructType\CreateSolarConnectionInput
     */
    public function setExpectedYearlyProduction($expectedYearlyProduction = null)
    {
        // validation for constraint: float
        if (!is_null($expectedYearlyProduction) && !(is_float($expectedYearlyProduction) || is_numeric($expectedYearlyProduction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($expectedYearlyProduction, true), gettype($expectedYearlyProduction)), __LINE__);
        }
        $this->ExpectedYearlyProduction = $expectedYearlyProduction;
        return $this;
    }
    /**
     * Get ConnectionId value
     * @return string|null
     */
    public function getConnectionId()
    {
        return $this->ConnectionId;
    }
    /**
     * Set ConnectionId value
     * @param string $connectionId
     * @return \CustomerManagement\StructType\CreateSolarConnectionInput
     */
    public function setConnectionId($connectionId = null)
    {
        // validation for constraint: string
        if (!is_null($connectionId) && !is_string($connectionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectionId, true), gettype($connectionId)), __LINE__);
        }
        $this->ConnectionId = $connectionId;
        return $this;
    }
}
