<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetAutoPhoneTestSettingsInput StructType
 * @subpackage Structs
 */
class SetAutoPhoneTestSettingsInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The EnablePhoneTest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EnablePhoneTest;
    /**
     * The PhoneTestIntervalDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PhoneTestIntervalDays;
    /**
     * The PhoneTestTime_MinutesAfterMidnight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PhoneTestTime_MinutesAfterMidnight;
    /**
     * Constructor method for SetAutoPhoneTestSettingsInput
     * @uses SetAutoPhoneTestSettingsInput::setCustomerId()
     * @uses SetAutoPhoneTestSettingsInput::setEnablePhoneTest()
     * @uses SetAutoPhoneTestSettingsInput::setPhoneTestIntervalDays()
     * @uses SetAutoPhoneTestSettingsInput::setPhoneTestTime_MinutesAfterMidnight()
     * @param int $customerId
     * @param bool $enablePhoneTest
     * @param int $phoneTestIntervalDays
     * @param int $phoneTestTime_MinutesAfterMidnight
     */
    public function __construct($customerId = null, $enablePhoneTest = null, $phoneTestIntervalDays = null, $phoneTestTime_MinutesAfterMidnight = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setEnablePhoneTest($enablePhoneTest)
            ->setPhoneTestIntervalDays($phoneTestIntervalDays)
            ->setPhoneTestTime_MinutesAfterMidnight($phoneTestTime_MinutesAfterMidnight);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\SetAutoPhoneTestSettingsInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get EnablePhoneTest value
     * @return bool
     */
    public function getEnablePhoneTest()
    {
        return $this->EnablePhoneTest;
    }
    /**
     * Set EnablePhoneTest value
     * @param bool $enablePhoneTest
     * @return \CustomerManagement\StructType\SetAutoPhoneTestSettingsInput
     */
    public function setEnablePhoneTest($enablePhoneTest = null)
    {
        // validation for constraint: boolean
        if (!is_null($enablePhoneTest) && !is_bool($enablePhoneTest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($enablePhoneTest)), __LINE__);
        }
        $this->EnablePhoneTest = $enablePhoneTest;
        return $this;
    }
    /**
     * Get PhoneTestIntervalDays value
     * @return int
     */
    public function getPhoneTestIntervalDays()
    {
        return $this->PhoneTestIntervalDays;
    }
    /**
     * Set PhoneTestIntervalDays value
     * @param int $phoneTestIntervalDays
     * @return \CustomerManagement\StructType\SetAutoPhoneTestSettingsInput
     */
    public function setPhoneTestIntervalDays($phoneTestIntervalDays = null)
    {
        // validation for constraint: int
        if (!is_null($phoneTestIntervalDays) && !is_numeric($phoneTestIntervalDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($phoneTestIntervalDays)), __LINE__);
        }
        $this->PhoneTestIntervalDays = $phoneTestIntervalDays;
        return $this;
    }
    /**
     * Get PhoneTestTime_MinutesAfterMidnight value
     * @return int
     */
    public function getPhoneTestTime_MinutesAfterMidnight()
    {
        return $this->PhoneTestTime_MinutesAfterMidnight;
    }
    /**
     * Set PhoneTestTime_MinutesAfterMidnight value
     * @param int $phoneTestTime_MinutesAfterMidnight
     * @return \CustomerManagement\StructType\SetAutoPhoneTestSettingsInput
     */
    public function setPhoneTestTime_MinutesAfterMidnight($phoneTestTime_MinutesAfterMidnight = null)
    {
        // validation for constraint: int
        if (!is_null($phoneTestTime_MinutesAfterMidnight) && !is_numeric($phoneTestTime_MinutesAfterMidnight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($phoneTestTime_MinutesAfterMidnight)), __LINE__);
        }
        $this->PhoneTestTime_MinutesAfterMidnight = $phoneTestTime_MinutesAfterMidnight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\SetAutoPhoneTestSettingsInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
