<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageSensorAutoUploadRule StructType
 * @subpackage Structs
 */
class ImageSensorAutoUploadRule extends AbstractStructBase
{
    /**
     * The RuleType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RuleType;
    /**
     * The StartTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartTime;
    /**
     * The EndTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndTime;
    /**
     * The DeviceIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfInt
     */
    public $DeviceIds;
    /**
     * The ActiveDays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfDayOfWeek
     */
    public $ActiveDays;
    /**
     * The ContactAddressesToSubscribe
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfLong
     */
    public $ContactAddressesToSubscribe;
    /**
     * Constructor method for ImageSensorAutoUploadRule
     * @uses ImageSensorAutoUploadRule::setRuleType()
     * @uses ImageSensorAutoUploadRule::setStartTime()
     * @uses ImageSensorAutoUploadRule::setEndTime()
     * @uses ImageSensorAutoUploadRule::setDeviceIds()
     * @uses ImageSensorAutoUploadRule::setActiveDays()
     * @uses ImageSensorAutoUploadRule::setContactAddressesToSubscribe()
     * @param string $ruleType
     * @param string $startTime
     * @param string $endTime
     * @param \CustomerManagement\ArrayType\ArrayOfInt $deviceIds
     * @param \CustomerManagement\ArrayType\ArrayOfDayOfWeek $activeDays
     * @param \CustomerManagement\ArrayType\ArrayOfLong $contactAddressesToSubscribe
     */
    public function __construct($ruleType = null, $startTime = null, $endTime = null, \CustomerManagement\ArrayType\ArrayOfInt $deviceIds = null, \CustomerManagement\ArrayType\ArrayOfDayOfWeek $activeDays = null, \CustomerManagement\ArrayType\ArrayOfLong $contactAddressesToSubscribe = null)
    {
        $this
            ->setRuleType($ruleType)
            ->setStartTime($startTime)
            ->setEndTime($endTime)
            ->setDeviceIds($deviceIds)
            ->setActiveDays($activeDays)
            ->setContactAddressesToSubscribe($contactAddressesToSubscribe);
    }
    /**
     * Get RuleType value
     * @return string
     */
    public function getRuleType()
    {
        return $this->RuleType;
    }
    /**
     * Set RuleType value
     * @uses \CustomerManagement\EnumType\ImageSensorAutoUploadRuleTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\ImageSensorAutoUploadRuleTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ruleType
     * @return \CustomerManagement\StructType\ImageSensorAutoUploadRule
     */
    public function setRuleType($ruleType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\ImageSensorAutoUploadRuleTypeEnum::valueIsValid($ruleType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\ImageSensorAutoUploadRuleTypeEnum', is_array($ruleType) ? implode(', ', $ruleType) : var_export($ruleType, true), implode(', ', \CustomerManagement\EnumType\ImageSensorAutoUploadRuleTypeEnum::getValidValues())), __LINE__);
        }
        $this->RuleType = $ruleType;
        return $this;
    }
    /**
     * Get StartTime value
     * @return string
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \CustomerManagement\StructType\ImageSensorAutoUploadRule
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startTime, true), gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get EndTime value
     * @return string
     */
    public function getEndTime()
    {
        return $this->EndTime;
    }
    /**
     * Set EndTime value
     * @param string $endTime
     * @return \CustomerManagement\StructType\ImageSensorAutoUploadRule
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endTime, true), gettype($endTime)), __LINE__);
        }
        $this->EndTime = $endTime;
        return $this;
    }
    /**
     * Get DeviceIds value
     * @return \CustomerManagement\ArrayType\ArrayOfInt|null
     */
    public function getDeviceIds()
    {
        return $this->DeviceIds;
    }
    /**
     * Set DeviceIds value
     * @param \CustomerManagement\ArrayType\ArrayOfInt $deviceIds
     * @return \CustomerManagement\StructType\ImageSensorAutoUploadRule
     */
    public function setDeviceIds(\CustomerManagement\ArrayType\ArrayOfInt $deviceIds = null)
    {
        $this->DeviceIds = $deviceIds;
        return $this;
    }
    /**
     * Get ActiveDays value
     * @return \CustomerManagement\ArrayType\ArrayOfDayOfWeek|null
     */
    public function getActiveDays()
    {
        return $this->ActiveDays;
    }
    /**
     * Set ActiveDays value
     * @param \CustomerManagement\ArrayType\ArrayOfDayOfWeek $activeDays
     * @return \CustomerManagement\StructType\ImageSensorAutoUploadRule
     */
    public function setActiveDays(\CustomerManagement\ArrayType\ArrayOfDayOfWeek $activeDays = null)
    {
        $this->ActiveDays = $activeDays;
        return $this;
    }
    /**
     * Get ContactAddressesToSubscribe value
     * @return \CustomerManagement\ArrayType\ArrayOfLong|null
     */
    public function getContactAddressesToSubscribe()
    {
        return $this->ContactAddressesToSubscribe;
    }
    /**
     * Set ContactAddressesToSubscribe value
     * @param \CustomerManagement\ArrayType\ArrayOfLong $contactAddressesToSubscribe
     * @return \CustomerManagement\StructType\ImageSensorAutoUploadRule
     */
    public function setContactAddressesToSubscribe(\CustomerManagement\ArrayType\ArrayOfLong $contactAddressesToSubscribe = null)
    {
        $this->ContactAddressesToSubscribe = $contactAddressesToSubscribe;
        return $this;
    }
}
