<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerRiskScore ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerRiskScore extends AbstractStructArrayBase
{
    /**
     * The CustomerRiskScore
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\CustomerRiskScore[]
     */
    public $CustomerRiskScore;
    /**
     * Constructor method for ArrayOfCustomerRiskScore
     * @uses ArrayOfCustomerRiskScore::setCustomerRiskScore()
     * @param \CustomerManagement\StructType\CustomerRiskScore[] $customerRiskScore
     */
    public function __construct(array $customerRiskScore = array())
    {
        $this
            ->setCustomerRiskScore($customerRiskScore);
    }
    /**
     * Get CustomerRiskScore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\CustomerRiskScore[]|null
     */
    public function getCustomerRiskScore()
    {
        return isset($this->CustomerRiskScore) ? $this->CustomerRiskScore : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerRiskScore method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerRiskScore method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerRiskScoreForArrayConstraintsFromSetCustomerRiskScore(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCustomerRiskScoreCustomerRiskScoreItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerRiskScoreCustomerRiskScoreItem instanceof \CustomerManagement\StructType\CustomerRiskScore) {
                $invalidValues[] = is_object($arrayOfCustomerRiskScoreCustomerRiskScoreItem) ? get_class($arrayOfCustomerRiskScoreCustomerRiskScoreItem) : sprintf('%s(%s)', gettype($arrayOfCustomerRiskScoreCustomerRiskScoreItem), var_export($arrayOfCustomerRiskScoreCustomerRiskScoreItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomerRiskScore property can only contain items of type \CustomerManagement\StructType\CustomerRiskScore, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomerRiskScore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\CustomerRiskScore[] $customerRiskScore
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerRiskScore
     */
    public function setCustomerRiskScore(array $customerRiskScore = array())
    {
        // validation for constraint: array
        if ('' !== ($customerRiskScoreArrayErrorMessage = self::validateCustomerRiskScoreForArrayConstraintsFromSetCustomerRiskScore($customerRiskScore))) {
            throw new \InvalidArgumentException($customerRiskScoreArrayErrorMessage, __LINE__);
        }
        if (is_null($customerRiskScore) || (is_array($customerRiskScore) && empty($customerRiskScore))) {
            unset($this->CustomerRiskScore);
        } else {
            $this->CustomerRiskScore = $customerRiskScore;
        }
        return $this;
    }
    /**
     * Add item to CustomerRiskScore value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\CustomerRiskScore $item
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerRiskScore
     */
    public function addToCustomerRiskScore(\CustomerManagement\StructType\CustomerRiskScore $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\CustomerRiskScore) {
            throw new \InvalidArgumentException(sprintf('The CustomerRiskScore property can only contain items of type \CustomerManagement\StructType\CustomerRiskScore, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomerRiskScore[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\CustomerRiskScore|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\CustomerRiskScore|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\CustomerRiskScore|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\CustomerRiskScore|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\CustomerRiskScore|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerRiskScore
     */
    public function getAttributeName()
    {
        return 'CustomerRiskScore';
    }
}
