<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RunSystemCheck StructType
 * @subpackage Structs
 */
class RunSystemCheck extends AbstractStructBase
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $category;
    /**
     * Constructor method for RunSystemCheck
     * @uses RunSystemCheck::setCustomerId()
     * @uses RunSystemCheck::setCategory()
     * @param int $customerId
     * @param string $category
     */
    public function __construct($customerId = null, $category = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setCategory($category);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\RunSystemCheck
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get category value
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @uses \CustomerManagement\EnumType\SystemCheckTestCategoryEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\SystemCheckTestCategoryEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $category
     * @return \CustomerManagement\StructType\RunSystemCheck
     */
    public function setCategory($category = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\SystemCheckTestCategoryEnum::valueIsValid($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\SystemCheckTestCategoryEnum', is_array($category) ? implode(', ', $category) : var_export($category, true), implode(', ', \CustomerManagement\EnumType\SystemCheckTestCategoryEnum::getValidValues())), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
}
