<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetScheduledAppointmentInput StructType
 * @subpackage Structs
 */
class GetScheduledAppointmentInput extends AbstractStructBase
{
    /**
     * The AppointmentId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AppointmentId;
    /**
     * Constructor method for GetScheduledAppointmentInput
     * @uses GetScheduledAppointmentInput::setAppointmentId()
     * @param int $appointmentId
     */
    public function __construct($appointmentId = null)
    {
        $this
            ->setAppointmentId($appointmentId);
    }
    /**
     * Get AppointmentId value
     * @return int
     */
    public function getAppointmentId()
    {
        return $this->AppointmentId;
    }
    /**
     * Set AppointmentId value
     * @param int $appointmentId
     * @return \CustomerManagement\StructType\GetScheduledAppointmentInput
     */
    public function setAppointmentId($appointmentId = null)
    {
        // validation for constraint: int
        if (!is_null($appointmentId) && !is_numeric($appointmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($appointmentId)), __LINE__);
        }
        $this->AppointmentId = $appointmentId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\GetScheduledAppointmentInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
