<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LookupCustomerIdForDealer StructType
 * @subpackage Structs
 */
class LookupCustomerIdForDealer extends AbstractStructBase
{
    /**
     * The dealerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $dealerId;
    /**
     * The receiverPhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $receiverPhoneNumber;
    /**
     * The acctNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $acctNumber;
    /**
     * Constructor method for LookupCustomerIdForDealer
     * @uses LookupCustomerIdForDealer::setDealerId()
     * @uses LookupCustomerIdForDealer::setReceiverPhoneNumber()
     * @uses LookupCustomerIdForDealer::setAcctNumber()
     * @param int $dealerId
     * @param string $receiverPhoneNumber
     * @param string $acctNumber
     */
    public function __construct($dealerId = null, $receiverPhoneNumber = null, $acctNumber = null)
    {
        $this
            ->setDealerId($dealerId)
            ->setReceiverPhoneNumber($receiverPhoneNumber)
            ->setAcctNumber($acctNumber);
    }
    /**
     * Get dealerId value
     * @return int
     */
    public function getDealerId()
    {
        return $this->dealerId;
    }
    /**
     * Set dealerId value
     * @param int $dealerId
     * @return \CustomerManagement\StructType\LookupCustomerIdForDealer
     */
    public function setDealerId($dealerId = null)
    {
        // validation for constraint: int
        if (!is_null($dealerId) && !(is_int($dealerId) || ctype_digit($dealerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dealerId, true), gettype($dealerId)), __LINE__);
        }
        $this->dealerId = $dealerId;
        return $this;
    }
    /**
     * Get receiverPhoneNumber value
     * @return string|null
     */
    public function getReceiverPhoneNumber()
    {
        return $this->receiverPhoneNumber;
    }
    /**
     * Set receiverPhoneNumber value
     * @param string $receiverPhoneNumber
     * @return \CustomerManagement\StructType\LookupCustomerIdForDealer
     */
    public function setReceiverPhoneNumber($receiverPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($receiverPhoneNumber) && !is_string($receiverPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverPhoneNumber, true), gettype($receiverPhoneNumber)), __LINE__);
        }
        $this->receiverPhoneNumber = $receiverPhoneNumber;
        return $this;
    }
    /**
     * Get acctNumber value
     * @return string|null
     */
    public function getAcctNumber()
    {
        return $this->acctNumber;
    }
    /**
     * Set acctNumber value
     * @param string $acctNumber
     * @return \CustomerManagement\StructType\LookupCustomerIdForDealer
     */
    public function setAcctNumber($acctNumber = null)
    {
        // validation for constraint: string
        if (!is_null($acctNumber) && !is_string($acctNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acctNumber, true), gettype($acctNumber)), __LINE__);
        }
        $this->acctNumber = $acctNumber;
        return $this;
    }
}
