<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotificationSubscription StructType
 * @subpackage Structs
 */
class NotificationSubscription extends AbstractStructBase
{
    /**
     * The NotificationType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NotificationType;
    /**
     * The DeviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * The ContactAddressId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ContactAddressId;
    /**
     * Constructor method for NotificationSubscription
     * @uses NotificationSubscription::setNotificationType()
     * @uses NotificationSubscription::setDeviceId()
     * @uses NotificationSubscription::setContactAddressId()
     * @param string $notificationType
     * @param int $deviceId
     * @param int $contactAddressId
     */
    public function __construct($notificationType = null, $deviceId = null, $contactAddressId = null)
    {
        $this
            ->setNotificationType($notificationType)
            ->setDeviceId($deviceId)
            ->setContactAddressId($contactAddressId);
    }
    /**
     * Get NotificationType value
     * @return string
     */
    public function getNotificationType()
    {
        return $this->NotificationType;
    }
    /**
     * Set NotificationType value
     * @uses \CustomerManagement\EnumType\NotificationTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\NotificationTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $notificationType
     * @return \CustomerManagement\StructType\NotificationSubscription
     */
    public function setNotificationType($notificationType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\NotificationTypeEnum::valueIsValid($notificationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\NotificationTypeEnum', is_array($notificationType) ? implode(', ', $notificationType) : var_export($notificationType, true), implode(', ', \CustomerManagement\EnumType\NotificationTypeEnum::getValidValues())), __LINE__);
        }
        $this->NotificationType = $notificationType;
        return $this;
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\NotificationSubscription
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !(is_int($deviceId) || ctype_digit($deviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get ContactAddressId value
     * @return int
     */
    public function getContactAddressId()
    {
        return $this->ContactAddressId;
    }
    /**
     * Set ContactAddressId value
     * @param int $contactAddressId
     * @return \CustomerManagement\StructType\NotificationSubscription
     */
    public function setContactAddressId($contactAddressId = null)
    {
        // validation for constraint: int
        if (!is_null($contactAddressId) && !(is_int($contactAddressId) || ctype_digit($contactAddressId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contactAddressId, true), gettype($contactAddressId)), __LINE__);
        }
        $this->ContactAddressId = $contactAddressId;
        return $this;
    }
}
