<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScheduledServiceDateInfoV2 StructType
 * @subpackage Structs
 */
class ScheduledServiceDateInfoV2 extends ScheduledServiceDateInfo
{
    /**
     * The ServiceDateEndRangeUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ServiceDateEndRangeUtc;
    /**
     * The CustomerLocalizedServiceDateEndRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CustomerLocalizedServiceDateEndRange;
    /**
     * The IsVirtual
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsVirtual;
    /**
     * The IncludeRepInfoInEmails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IncludeRepInfoInEmails;
    /**
     * The EstimatedDurationMinutes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EstimatedDurationMinutes;
    /**
     * The AppointmentTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum
     */
    public $AppointmentTypes;
    /**
     * The MeetingLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeetingLocation;
    /**
     * The CustomerFacingInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerFacingInfo;
    /**
     * Constructor method for ScheduledServiceDateInfoV2
     * @uses ScheduledServiceDateInfoV2::setServiceDateEndRangeUtc()
     * @uses ScheduledServiceDateInfoV2::setCustomerLocalizedServiceDateEndRange()
     * @uses ScheduledServiceDateInfoV2::setIsVirtual()
     * @uses ScheduledServiceDateInfoV2::setIncludeRepInfoInEmails()
     * @uses ScheduledServiceDateInfoV2::setEstimatedDurationMinutes()
     * @uses ScheduledServiceDateInfoV2::setAppointmentTypes()
     * @uses ScheduledServiceDateInfoV2::setMeetingLocation()
     * @uses ScheduledServiceDateInfoV2::setCustomerFacingInfo()
     * @param string $serviceDateEndRangeUtc
     * @param string $customerLocalizedServiceDateEndRange
     * @param bool $isVirtual
     * @param bool $includeRepInfoInEmails
     * @param int $estimatedDurationMinutes
     * @param \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum $appointmentTypes
     * @param string $meetingLocation
     * @param string $customerFacingInfo
     */
    public function __construct($serviceDateEndRangeUtc = null, $customerLocalizedServiceDateEndRange = null, $isVirtual = null, $includeRepInfoInEmails = null, $estimatedDurationMinutes = null, \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum $appointmentTypes = null, $meetingLocation = null, $customerFacingInfo = null)
    {
        $this
            ->setServiceDateEndRangeUtc($serviceDateEndRangeUtc)
            ->setCustomerLocalizedServiceDateEndRange($customerLocalizedServiceDateEndRange)
            ->setIsVirtual($isVirtual)
            ->setIncludeRepInfoInEmails($includeRepInfoInEmails)
            ->setEstimatedDurationMinutes($estimatedDurationMinutes)
            ->setAppointmentTypes($appointmentTypes)
            ->setMeetingLocation($meetingLocation)
            ->setCustomerFacingInfo($customerFacingInfo);
    }
    /**
     * Get ServiceDateEndRangeUtc value
     * @return string
     */
    public function getServiceDateEndRangeUtc()
    {
        return $this->ServiceDateEndRangeUtc;
    }
    /**
     * Set ServiceDateEndRangeUtc value
     * @param string $serviceDateEndRangeUtc
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setServiceDateEndRangeUtc($serviceDateEndRangeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDateEndRangeUtc) && !is_string($serviceDateEndRangeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceDateEndRangeUtc, true), gettype($serviceDateEndRangeUtc)), __LINE__);
        }
        $this->ServiceDateEndRangeUtc = $serviceDateEndRangeUtc;
        return $this;
    }
    /**
     * Get CustomerLocalizedServiceDateEndRange value
     * @return string
     */
    public function getCustomerLocalizedServiceDateEndRange()
    {
        return $this->CustomerLocalizedServiceDateEndRange;
    }
    /**
     * Set CustomerLocalizedServiceDateEndRange value
     * @param string $customerLocalizedServiceDateEndRange
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setCustomerLocalizedServiceDateEndRange($customerLocalizedServiceDateEndRange = null)
    {
        // validation for constraint: string
        if (!is_null($customerLocalizedServiceDateEndRange) && !is_string($customerLocalizedServiceDateEndRange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerLocalizedServiceDateEndRange, true), gettype($customerLocalizedServiceDateEndRange)), __LINE__);
        }
        $this->CustomerLocalizedServiceDateEndRange = $customerLocalizedServiceDateEndRange;
        return $this;
    }
    /**
     * Get IsVirtual value
     * @return bool
     */
    public function getIsVirtual()
    {
        return $this->IsVirtual;
    }
    /**
     * Set IsVirtual value
     * @param bool $isVirtual
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setIsVirtual($isVirtual = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVirtual) && !is_bool($isVirtual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVirtual, true), gettype($isVirtual)), __LINE__);
        }
        $this->IsVirtual = $isVirtual;
        return $this;
    }
    /**
     * Get IncludeRepInfoInEmails value
     * @return bool
     */
    public function getIncludeRepInfoInEmails()
    {
        return $this->IncludeRepInfoInEmails;
    }
    /**
     * Set IncludeRepInfoInEmails value
     * @param bool $includeRepInfoInEmails
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setIncludeRepInfoInEmails($includeRepInfoInEmails = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeRepInfoInEmails) && !is_bool($includeRepInfoInEmails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeRepInfoInEmails, true), gettype($includeRepInfoInEmails)), __LINE__);
        }
        $this->IncludeRepInfoInEmails = $includeRepInfoInEmails;
        return $this;
    }
    /**
     * Get EstimatedDurationMinutes value
     * @return int
     */
    public function getEstimatedDurationMinutes()
    {
        return $this->EstimatedDurationMinutes;
    }
    /**
     * Set EstimatedDurationMinutes value
     * @param int $estimatedDurationMinutes
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setEstimatedDurationMinutes($estimatedDurationMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($estimatedDurationMinutes) && !(is_int($estimatedDurationMinutes) || ctype_digit($estimatedDurationMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($estimatedDurationMinutes, true), gettype($estimatedDurationMinutes)), __LINE__);
        }
        $this->EstimatedDurationMinutes = $estimatedDurationMinutes;
        return $this;
    }
    /**
     * Get AppointmentTypes value
     * @return \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum|null
     */
    public function getAppointmentTypes()
    {
        return $this->AppointmentTypes;
    }
    /**
     * Set AppointmentTypes value
     * @param \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum $appointmentTypes
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setAppointmentTypes(\CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum $appointmentTypes = null)
    {
        $this->AppointmentTypes = $appointmentTypes;
        return $this;
    }
    /**
     * Get MeetingLocation value
     * @return string|null
     */
    public function getMeetingLocation()
    {
        return $this->MeetingLocation;
    }
    /**
     * Set MeetingLocation value
     * @param string $meetingLocation
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setMeetingLocation($meetingLocation = null)
    {
        // validation for constraint: string
        if (!is_null($meetingLocation) && !is_string($meetingLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meetingLocation, true), gettype($meetingLocation)), __LINE__);
        }
        $this->MeetingLocation = $meetingLocation;
        return $this;
    }
    /**
     * Get CustomerFacingInfo value
     * @return string|null
     */
    public function getCustomerFacingInfo()
    {
        return $this->CustomerFacingInfo;
    }
    /**
     * Set CustomerFacingInfo value
     * @param string $customerFacingInfo
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setCustomerFacingInfo($customerFacingInfo = null)
    {
        // validation for constraint: string
        if (!is_null($customerFacingInfo) && !is_string($customerFacingInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerFacingInfo, true), gettype($customerFacingInfo)), __LINE__);
        }
        $this->CustomerFacingInfo = $customerFacingInfo;
        return $this;
    }
}
