<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteEnterpriseGroupOutput StructType
 * @subpackage Structs
 */
class DeleteEnterpriseGroupOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The SystemGroupId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemGroupId;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for DeleteEnterpriseGroupOutput
     * @uses DeleteEnterpriseGroupOutput::setSuccess()
     * @uses DeleteEnterpriseGroupOutput::setSystemGroupId()
     * @uses DeleteEnterpriseGroupOutput::setErrorMessage()
     * @param bool $success
     * @param int $systemGroupId
     * @param string $errorMessage
     */
    public function __construct($success = null, $systemGroupId = null, $errorMessage = null)
    {
        $this
            ->setSuccess($success)
            ->setSystemGroupId($systemGroupId)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\DeleteEnterpriseGroupOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get SystemGroupId value
     * @return int
     */
    public function getSystemGroupId()
    {
        return $this->SystemGroupId;
    }
    /**
     * Set SystemGroupId value
     * @param int $systemGroupId
     * @return \CustomerManagement\StructType\DeleteEnterpriseGroupOutput
     */
    public function setSystemGroupId($systemGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($systemGroupId) && !(is_int($systemGroupId) || ctype_digit($systemGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($systemGroupId, true), gettype($systemGroupId)), __LINE__);
        }
        $this->SystemGroupId = $systemGroupId;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\DeleteEnterpriseGroupOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
}
