<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResetCustomerPasswordInput StructType
 * @subpackage Structs
 */
class ResetCustomerPasswordInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The UnlockAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UnlockAccount;
    /**
     * The LoginName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginName;
    /**
     * Constructor method for ResetCustomerPasswordInput
     * @uses ResetCustomerPasswordInput::setCustomerId()
     * @uses ResetCustomerPasswordInput::setUnlockAccount()
     * @uses ResetCustomerPasswordInput::setLoginName()
     * @param int $customerId
     * @param bool $unlockAccount
     * @param string $loginName
     */
    public function __construct($customerId = null, $unlockAccount = null, $loginName = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setUnlockAccount($unlockAccount)
            ->setLoginName($loginName);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\ResetCustomerPasswordInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get UnlockAccount value
     * @return bool
     */
    public function getUnlockAccount()
    {
        return $this->UnlockAccount;
    }
    /**
     * Set UnlockAccount value
     * @param bool $unlockAccount
     * @return \CustomerManagement\StructType\ResetCustomerPasswordInput
     */
    public function setUnlockAccount($unlockAccount = null)
    {
        // validation for constraint: boolean
        if (!is_null($unlockAccount) && !is_bool($unlockAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($unlockAccount)), __LINE__);
        }
        $this->UnlockAccount = $unlockAccount;
        return $this;
    }
    /**
     * Get LoginName value
     * @return string|null
     */
    public function getLoginName()
    {
        return $this->LoginName;
    }
    /**
     * Set LoginName value
     * @param string $loginName
     * @return \CustomerManagement\StructType\ResetCustomerPasswordInput
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loginName)), __LINE__);
        }
        $this->LoginName = $loginName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\ResetCustomerPasswordInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
