<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for GsmBarSignalLevelEnum EnumType
 * @subpackage Enumerations
 */
class GsmBarSignalLevelEnum
{
    /**
     * Constant for value 'Bars0'
     * @return string 'Bars0'
     */
    const VALUE_BARS_0 = 'Bars0';
    /**
     * Constant for value 'Bars1'
     * @return string 'Bars1'
     */
    const VALUE_BARS_1 = 'Bars1';
    /**
     * Constant for value 'Bars2'
     * @return string 'Bars2'
     */
    const VALUE_BARS_2 = 'Bars2';
    /**
     * Constant for value 'Bars3'
     * @return string 'Bars3'
     */
    const VALUE_BARS_3 = 'Bars3';
    /**
     * Constant for value 'Bars4'
     * @return string 'Bars4'
     */
    const VALUE_BARS_4 = 'Bars4';
    /**
     * Constant for value 'Bars5'
     * @return string 'Bars5'
     */
    const VALUE_BARS_5 = 'Bars5';
    /**
     * Constant for value 'Bars6'
     * @return string 'Bars6'
     */
    const VALUE_BARS_6 = 'Bars6';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BARS_0
     * @uses self::VALUE_BARS_1
     * @uses self::VALUE_BARS_2
     * @uses self::VALUE_BARS_3
     * @uses self::VALUE_BARS_4
     * @uses self::VALUE_BARS_5
     * @uses self::VALUE_BARS_6
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BARS_0,
            self::VALUE_BARS_1,
            self::VALUE_BARS_2,
            self::VALUE_BARS_3,
            self::VALUE_BARS_4,
            self::VALUE_BARS_5,
            self::VALUE_BARS_6,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
