<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateInstallerSalesRepInput StructType
 * @subpackage Structs
 */
class UpdateInstallerSalesRepInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The SalesRepLoginName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesRepLoginName;
    /**
     * The InstallerRepLoginName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InstallerRepLoginName;
    /**
     * Constructor method for UpdateInstallerSalesRepInput
     * @uses UpdateInstallerSalesRepInput::setCustomerId()
     * @uses UpdateInstallerSalesRepInput::setSalesRepLoginName()
     * @uses UpdateInstallerSalesRepInput::setInstallerRepLoginName()
     * @param int $customerId
     * @param string $salesRepLoginName
     * @param string $installerRepLoginName
     */
    public function __construct($customerId = null, $salesRepLoginName = null, $installerRepLoginName = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setSalesRepLoginName($salesRepLoginName)
            ->setInstallerRepLoginName($installerRepLoginName);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateInstallerSalesRepInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SalesRepLoginName value
     * @return string|null
     */
    public function getSalesRepLoginName()
    {
        return $this->SalesRepLoginName;
    }
    /**
     * Set SalesRepLoginName value
     * @param string $salesRepLoginName
     * @return \CustomerManagement\StructType\UpdateInstallerSalesRepInput
     */
    public function setSalesRepLoginName($salesRepLoginName = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepLoginName) && !is_string($salesRepLoginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepLoginName, true), gettype($salesRepLoginName)), __LINE__);
        }
        $this->SalesRepLoginName = $salesRepLoginName;
        return $this;
    }
    /**
     * Get InstallerRepLoginName value
     * @return string|null
     */
    public function getInstallerRepLoginName()
    {
        return $this->InstallerRepLoginName;
    }
    /**
     * Set InstallerRepLoginName value
     * @param string $installerRepLoginName
     * @return \CustomerManagement\StructType\UpdateInstallerSalesRepInput
     */
    public function setInstallerRepLoginName($installerRepLoginName = null)
    {
        // validation for constraint: string
        if (!is_null($installerRepLoginName) && !is_string($installerRepLoginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installerRepLoginName, true), gettype($installerRepLoginName)), __LINE__);
        }
        $this->InstallerRepLoginName = $installerRepLoginName;
        return $this;
    }
}
