<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferAccountOutput StructType
 * @subpackage Structs
 */
class TransferAccountOutput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The SuccessfullyTransferred
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SuccessfullyTransferred;
    /**
     * The SafeToTransfer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SafeToTransfer;
    /**
     * The Reason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reason;
    /**
     * Constructor method for TransferAccountOutput
     * @uses TransferAccountOutput::setCustomerId()
     * @uses TransferAccountOutput::setSuccessfullyTransferred()
     * @uses TransferAccountOutput::setSafeToTransfer()
     * @uses TransferAccountOutput::setReason()
     * @param int $customerId
     * @param bool $successfullyTransferred
     * @param bool $safeToTransfer
     * @param string $reason
     */
    public function __construct($customerId = null, $successfullyTransferred = null, $safeToTransfer = null, $reason = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setSuccessfullyTransferred($successfullyTransferred)
            ->setSafeToTransfer($safeToTransfer)
            ->setReason($reason);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\TransferAccountOutput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SuccessfullyTransferred value
     * @return bool
     */
    public function getSuccessfullyTransferred()
    {
        return $this->SuccessfullyTransferred;
    }
    /**
     * Set SuccessfullyTransferred value
     * @param bool $successfullyTransferred
     * @return \CustomerManagement\StructType\TransferAccountOutput
     */
    public function setSuccessfullyTransferred($successfullyTransferred = null)
    {
        // validation for constraint: boolean
        if (!is_null($successfullyTransferred) && !is_bool($successfullyTransferred)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($successfullyTransferred, true), gettype($successfullyTransferred)), __LINE__);
        }
        $this->SuccessfullyTransferred = $successfullyTransferred;
        return $this;
    }
    /**
     * Get SafeToTransfer value
     * @return bool
     */
    public function getSafeToTransfer()
    {
        return $this->SafeToTransfer;
    }
    /**
     * Set SafeToTransfer value
     * @param bool $safeToTransfer
     * @return \CustomerManagement\StructType\TransferAccountOutput
     */
    public function setSafeToTransfer($safeToTransfer = null)
    {
        // validation for constraint: boolean
        if (!is_null($safeToTransfer) && !is_bool($safeToTransfer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($safeToTransfer, true), gettype($safeToTransfer)), __LINE__);
        }
        $this->SafeToTransfer = $safeToTransfer;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \CustomerManagement\StructType\TransferAccountOutput
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
}
