<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSensorTypeIDQolsysInput StructType
 * @subpackage Structs
 */
class UpdateSensorTypeIDQolsysInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The SensorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SensorId;
    /**
     * The SensorType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SensorType;
    /**
     * The DeviceClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeviceClass;
    /**
     * The PanelGroupId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PanelGroupId;
    /**
     * Constructor method for UpdateSensorTypeIDQolsysInput
     * @uses UpdateSensorTypeIDQolsysInput::setCustomerId()
     * @uses UpdateSensorTypeIDQolsysInput::setSensorId()
     * @uses UpdateSensorTypeIDQolsysInput::setSensorType()
     * @uses UpdateSensorTypeIDQolsysInput::setDeviceClass()
     * @uses UpdateSensorTypeIDQolsysInput::setPanelGroupId()
     * @param int $customerId
     * @param int $sensorId
     * @param string $sensorType
     * @param string $deviceClass
     * @param int $panelGroupId
     */
    public function __construct($customerId = null, $sensorId = null, $sensorType = null, $deviceClass = null, $panelGroupId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setSensorId($sensorId)
            ->setSensorType($sensorType)
            ->setDeviceClass($deviceClass)
            ->setPanelGroupId($panelGroupId);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateSensorTypeIDQolsysInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SensorId value
     * @return int
     */
    public function getSensorId()
    {
        return $this->SensorId;
    }
    /**
     * Set SensorId value
     * @param int $sensorId
     * @return \CustomerManagement\StructType\UpdateSensorTypeIDQolsysInput
     */
    public function setSensorId($sensorId = null)
    {
        // validation for constraint: int
        if (!is_null($sensorId) && !(is_int($sensorId) || ctype_digit($sensorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sensorId, true), gettype($sensorId)), __LINE__);
        }
        $this->SensorId = $sensorId;
        return $this;
    }
    /**
     * Get SensorType value
     * @return string
     */
    public function getSensorType()
    {
        return $this->SensorType;
    }
    /**
     * Set SensorType value
     * @uses \CustomerManagement\EnumType\IQPanelSensorTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\IQPanelSensorTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sensorType
     * @return \CustomerManagement\StructType\UpdateSensorTypeIDQolsysInput
     */
    public function setSensorType($sensorType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\IQPanelSensorTypeEnum::valueIsValid($sensorType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\IQPanelSensorTypeEnum', is_array($sensorType) ? implode(', ', $sensorType) : var_export($sensorType, true), implode(', ', \CustomerManagement\EnumType\IQPanelSensorTypeEnum::getValidValues())), __LINE__);
        }
        $this->SensorType = $sensorType;
        return $this;
    }
    /**
     * Get DeviceClass value
     * @return string
     */
    public function getDeviceClass()
    {
        return $this->DeviceClass;
    }
    /**
     * Set DeviceClass value
     * @uses \CustomerManagement\EnumType\DeviceClassEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\DeviceClassEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceClass
     * @return \CustomerManagement\StructType\UpdateSensorTypeIDQolsysInput
     */
    public function setDeviceClass($deviceClass = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\DeviceClassEnum::valueIsValid($deviceClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\DeviceClassEnum', is_array($deviceClass) ? implode(', ', $deviceClass) : var_export($deviceClass, true), implode(', ', \CustomerManagement\EnumType\DeviceClassEnum::getValidValues())), __LINE__);
        }
        $this->DeviceClass = $deviceClass;
        return $this;
    }
    /**
     * Get PanelGroupId value
     * @return int
     */
    public function getPanelGroupId()
    {
        return $this->PanelGroupId;
    }
    /**
     * Set PanelGroupId value
     * @param int $panelGroupId
     * @return \CustomerManagement\StructType\UpdateSensorTypeIDQolsysInput
     */
    public function setPanelGroupId($panelGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($panelGroupId) && !(is_int($panelGroupId) || ctype_digit($panelGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($panelGroupId, true), gettype($panelGroupId)), __LINE__);
        }
        $this->PanelGroupId = $panelGroupId;
        return $this;
    }
}
