<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TroubleConditionOutput StructType
 * @subpackage Structs
 */
class TroubleConditionOutput extends AbstractStructBase
{
    /**
     * The DeviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * The TroubleConditionTypeEnum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TroubleConditionTypeEnum;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The ShortDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShortDescription;
    /**
     * Constructor method for TroubleConditionOutput
     * @uses TroubleConditionOutput::setDeviceId()
     * @uses TroubleConditionOutput::setTroubleConditionTypeEnum()
     * @uses TroubleConditionOutput::setStartDate()
     * @uses TroubleConditionOutput::setShortDescription()
     * @param int $deviceId
     * @param string $troubleConditionTypeEnum
     * @param string $startDate
     * @param string $shortDescription
     */
    public function __construct($deviceId = null, $troubleConditionTypeEnum = null, $startDate = null, $shortDescription = null)
    {
        $this
            ->setDeviceId($deviceId)
            ->setTroubleConditionTypeEnum($troubleConditionTypeEnum)
            ->setStartDate($startDate)
            ->setShortDescription($shortDescription);
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\TroubleConditionOutput
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !(is_int($deviceId) || ctype_digit($deviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get TroubleConditionTypeEnum value
     * @return string
     */
    public function getTroubleConditionTypeEnum()
    {
        return $this->TroubleConditionTypeEnum;
    }
    /**
     * Set TroubleConditionTypeEnum value
     * @uses \CustomerManagement\EnumType\TroubleConditionTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\TroubleConditionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $troubleConditionTypeEnum
     * @return \CustomerManagement\StructType\TroubleConditionOutput
     */
    public function setTroubleConditionTypeEnum($troubleConditionTypeEnum = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\TroubleConditionTypeEnum::valueIsValid($troubleConditionTypeEnum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\TroubleConditionTypeEnum', is_array($troubleConditionTypeEnum) ? implode(', ', $troubleConditionTypeEnum) : var_export($troubleConditionTypeEnum, true), implode(', ', \CustomerManagement\EnumType\TroubleConditionTypeEnum::getValidValues())), __LINE__);
        }
        $this->TroubleConditionTypeEnum = $troubleConditionTypeEnum;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \CustomerManagement\StructType\TroubleConditionOutput
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get ShortDescription value
     * @return string|null
     */
    public function getShortDescription()
    {
        return $this->ShortDescription;
    }
    /**
     * Set ShortDescription value
     * @param string $shortDescription
     * @return \CustomerManagement\StructType\TroubleConditionOutput
     */
    public function setShortDescription($shortDescription = null)
    {
        // validation for constraint: string
        if (!is_null($shortDescription) && !is_string($shortDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortDescription, true), gettype($shortDescription)), __LINE__);
        }
        $this->ShortDescription = $shortDescription;
        return $this;
    }
}
