<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SwapModemInput StructType
 * @subpackage Structs
 */
class SwapModemInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The RestoreBackedUpSettingsAfterSwap
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $RestoreBackedUpSettingsAfterSwap;
    /**
     * The RestoreNetworkAfterSwap
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $RestoreNetworkAfterSwap;
    /**
     * The NewSerialNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewSerialNumber;
    /**
     * The SwapReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SwapReason;
    /**
     * The SpecialRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SpecialRequest;
    /**
     * Constructor method for SwapModemInput
     * @uses SwapModemInput::setCustomerId()
     * @uses SwapModemInput::setRestoreBackedUpSettingsAfterSwap()
     * @uses SwapModemInput::setRestoreNetworkAfterSwap()
     * @uses SwapModemInput::setNewSerialNumber()
     * @uses SwapModemInput::setSwapReason()
     * @uses SwapModemInput::setSpecialRequest()
     * @param int $customerId
     * @param bool $restoreBackedUpSettingsAfterSwap
     * @param bool $restoreNetworkAfterSwap
     * @param string $newSerialNumber
     * @param string $swapReason
     * @param string $specialRequest
     */
    public function __construct($customerId = null, $restoreBackedUpSettingsAfterSwap = null, $restoreNetworkAfterSwap = null, $newSerialNumber = null, $swapReason = null, $specialRequest = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setRestoreBackedUpSettingsAfterSwap($restoreBackedUpSettingsAfterSwap)
            ->setRestoreNetworkAfterSwap($restoreNetworkAfterSwap)
            ->setNewSerialNumber($newSerialNumber)
            ->setSwapReason($swapReason)
            ->setSpecialRequest($specialRequest);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\SwapModemInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get RestoreBackedUpSettingsAfterSwap value
     * @return bool
     */
    public function getRestoreBackedUpSettingsAfterSwap()
    {
        return $this->RestoreBackedUpSettingsAfterSwap;
    }
    /**
     * Set RestoreBackedUpSettingsAfterSwap value
     * @param bool $restoreBackedUpSettingsAfterSwap
     * @return \CustomerManagement\StructType\SwapModemInput
     */
    public function setRestoreBackedUpSettingsAfterSwap($restoreBackedUpSettingsAfterSwap = null)
    {
        // validation for constraint: boolean
        if (!is_null($restoreBackedUpSettingsAfterSwap) && !is_bool($restoreBackedUpSettingsAfterSwap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($restoreBackedUpSettingsAfterSwap, true), gettype($restoreBackedUpSettingsAfterSwap)), __LINE__);
        }
        $this->RestoreBackedUpSettingsAfterSwap = $restoreBackedUpSettingsAfterSwap;
        return $this;
    }
    /**
     * Get RestoreNetworkAfterSwap value
     * @return bool
     */
    public function getRestoreNetworkAfterSwap()
    {
        return $this->RestoreNetworkAfterSwap;
    }
    /**
     * Set RestoreNetworkAfterSwap value
     * @param bool $restoreNetworkAfterSwap
     * @return \CustomerManagement\StructType\SwapModemInput
     */
    public function setRestoreNetworkAfterSwap($restoreNetworkAfterSwap = null)
    {
        // validation for constraint: boolean
        if (!is_null($restoreNetworkAfterSwap) && !is_bool($restoreNetworkAfterSwap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($restoreNetworkAfterSwap, true), gettype($restoreNetworkAfterSwap)), __LINE__);
        }
        $this->RestoreNetworkAfterSwap = $restoreNetworkAfterSwap;
        return $this;
    }
    /**
     * Get NewSerialNumber value
     * @return string|null
     */
    public function getNewSerialNumber()
    {
        return $this->NewSerialNumber;
    }
    /**
     * Set NewSerialNumber value
     * @param string $newSerialNumber
     * @return \CustomerManagement\StructType\SwapModemInput
     */
    public function setNewSerialNumber($newSerialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($newSerialNumber) && !is_string($newSerialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newSerialNumber, true), gettype($newSerialNumber)), __LINE__);
        }
        $this->NewSerialNumber = $newSerialNumber;
        return $this;
    }
    /**
     * Get SwapReason value
     * @return string|null
     */
    public function getSwapReason()
    {
        return $this->SwapReason;
    }
    /**
     * Set SwapReason value
     * @param string $swapReason
     * @return \CustomerManagement\StructType\SwapModemInput
     */
    public function setSwapReason($swapReason = null)
    {
        // validation for constraint: string
        if (!is_null($swapReason) && !is_string($swapReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($swapReason, true), gettype($swapReason)), __LINE__);
        }
        $this->SwapReason = $swapReason;
        return $this;
    }
    /**
     * Get SpecialRequest value
     * @return string|null
     */
    public function getSpecialRequest()
    {
        return $this->SpecialRequest;
    }
    /**
     * Set SpecialRequest value
     * @param string $specialRequest
     * @return \CustomerManagement\StructType\SwapModemInput
     */
    public function setSpecialRequest($specialRequest = null)
    {
        // validation for constraint: string
        if (!is_null($specialRequest) && !is_string($specialRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialRequest, true), gettype($specialRequest)), __LINE__);
        }
        $this->SpecialRequest = $specialRequest;
        return $this;
    }
}
