<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDeviceNotes StructType
 * @subpackage Structs
 */
class GetDeviceNotes extends AbstractStructBase
{
    /**
     * The customerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerID;
    /**
     * Constructor method for GetDeviceNotes
     * @uses GetDeviceNotes::setCustomerID()
     * @param int $customerID
     */
    public function __construct($customerID = null)
    {
        $this
            ->setCustomerID($customerID);
    }
    /**
     * Get customerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->customerID;
    }
    /**
     * Set customerID value
     * @param int $customerID
     * @return \CustomerManagement\StructType\GetDeviceNotes
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !(is_int($customerID) || ctype_digit($customerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->customerID = $customerID;
        return $this;
    }
}
