<?php

namespace CustomerManagement\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for RRIReportStatusEnum EnumType
 * @subpackage Enumerations
 */
class RRIReportStatusEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NotFound'
     * @return string 'NotFound'
     */
    const VALUE_NOT_FOUND = 'NotFound';
    /**
     * Constant for value 'Pending'
     * @return string 'Pending'
     */
    const VALUE_PENDING = 'Pending';
    /**
     * Constant for value 'Failed'
     * @return string 'Failed'
     */
    const VALUE_FAILED = 'Failed';
    /**
     * Constant for value 'SystemIsBusy'
     * @return string 'SystemIsBusy'
     */
    const VALUE_SYSTEM_IS_BUSY = 'SystemIsBusy';
    /**
     * Constant for value 'BadInputValue'
     * @return string 'BadInputValue'
     */
    const VALUE_BAD_INPUT_VALUE = 'BadInputValue';
    /**
     * Constant for value 'Complete'
     * @return string 'Complete'
     */
    const VALUE_COMPLETE = 'Complete';
    /**
     * Constant for value 'BadRepLoginCredentials'
     * @return string 'BadRepLoginCredentials'
     */
    const VALUE_BAD_REP_LOGIN_CREDENTIALS = 'BadRepLoginCredentials';
    /**
     * Constant for value 'FailAndRetry'
     * @return string 'FailAndRetry'
     */
    const VALUE_FAIL_AND_RETRY = 'FailAndRetry';
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_FOUND
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_FAILED
     * @uses self::VALUE_SYSTEM_IS_BUSY
     * @uses self::VALUE_BAD_INPUT_VALUE
     * @uses self::VALUE_COMPLETE
     * @uses self::VALUE_BAD_REP_LOGIN_CREDENTIALS
     * @uses self::VALUE_FAIL_AND_RETRY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_FOUND,
            self::VALUE_PENDING,
            self::VALUE_FAILED,
            self::VALUE_SYSTEM_IS_BUSY,
            self::VALUE_BAD_INPUT_VALUE,
            self::VALUE_COMPLETE,
            self::VALUE_BAD_REP_LOGIN_CREDENTIALS,
            self::VALUE_FAIL_AND_RETRY,
        );
    }
}
