<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCommitmentInput StructType
 * @subpackage Structs
 */
class UpdateCommitmentInput extends AbstractStructBase
{
    /**
     * The CommitmentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CommitmentId;
    /**
     * The ExpectedInstallDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExpectedInstallDate;
    /**
     * The ExpectedPanelType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExpectedPanelType;
    /**
     * The ExpectedNetwork
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExpectedNetwork;
    /**
     * The ExpectedInstallerLogin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpectedInstallerLogin;
    /**
     * Constructor method for UpdateCommitmentInput
     * @uses UpdateCommitmentInput::setCommitmentId()
     * @uses UpdateCommitmentInput::setExpectedInstallDate()
     * @uses UpdateCommitmentInput::setExpectedPanelType()
     * @uses UpdateCommitmentInput::setExpectedNetwork()
     * @uses UpdateCommitmentInput::setExpectedInstallerLogin()
     * @param int $commitmentId
     * @param string $expectedInstallDate
     * @param string $expectedPanelType
     * @param string $expectedNetwork
     * @param string $expectedInstallerLogin
     */
    public function __construct($commitmentId = null, $expectedInstallDate = null, $expectedPanelType = null, $expectedNetwork = null, $expectedInstallerLogin = null)
    {
        $this
            ->setCommitmentId($commitmentId)
            ->setExpectedInstallDate($expectedInstallDate)
            ->setExpectedPanelType($expectedPanelType)
            ->setExpectedNetwork($expectedNetwork)
            ->setExpectedInstallerLogin($expectedInstallerLogin);
    }
    /**
     * Get CommitmentId value
     * @return int
     */
    public function getCommitmentId()
    {
        return $this->CommitmentId;
    }
    /**
     * Set CommitmentId value
     * @param int $commitmentId
     * @return \CustomerManagement\StructType\UpdateCommitmentInput
     */
    public function setCommitmentId($commitmentId = null)
    {
        // validation for constraint: int
        if (!is_null($commitmentId) && !(is_int($commitmentId) || ctype_digit($commitmentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($commitmentId, true), gettype($commitmentId)), __LINE__);
        }
        $this->CommitmentId = $commitmentId;
        return $this;
    }
    /**
     * Get ExpectedInstallDate value
     * @return string
     */
    public function getExpectedInstallDate()
    {
        return $this->ExpectedInstallDate;
    }
    /**
     * Set ExpectedInstallDate value
     * @param string $expectedInstallDate
     * @return \CustomerManagement\StructType\UpdateCommitmentInput
     */
    public function setExpectedInstallDate($expectedInstallDate = null)
    {
        // validation for constraint: string
        if (!is_null($expectedInstallDate) && !is_string($expectedInstallDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expectedInstallDate, true), gettype($expectedInstallDate)), __LINE__);
        }
        $this->ExpectedInstallDate = $expectedInstallDate;
        return $this;
    }
    /**
     * Get ExpectedPanelType value
     * @return string
     */
    public function getExpectedPanelType()
    {
        return $this->ExpectedPanelType;
    }
    /**
     * Set ExpectedPanelType value
     * @uses \CustomerManagement\EnumType\PanelTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\PanelTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $expectedPanelType
     * @return \CustomerManagement\StructType\UpdateCommitmentInput
     */
    public function setExpectedPanelType($expectedPanelType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\PanelTypeEnum::valueIsValid($expectedPanelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\PanelTypeEnum', is_array($expectedPanelType) ? implode(', ', $expectedPanelType) : var_export($expectedPanelType, true), implode(', ', \CustomerManagement\EnumType\PanelTypeEnum::getValidValues())), __LINE__);
        }
        $this->ExpectedPanelType = $expectedPanelType;
        return $this;
    }
    /**
     * Get ExpectedNetwork value
     * @return string
     */
    public function getExpectedNetwork()
    {
        return $this->ExpectedNetwork;
    }
    /**
     * Set ExpectedNetwork value
     * @uses \CustomerManagement\EnumType\NetworkEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\NetworkEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $expectedNetwork
     * @return \CustomerManagement\StructType\UpdateCommitmentInput
     */
    public function setExpectedNetwork($expectedNetwork = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\NetworkEnum::valueIsValid($expectedNetwork)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\NetworkEnum', is_array($expectedNetwork) ? implode(', ', $expectedNetwork) : var_export($expectedNetwork, true), implode(', ', \CustomerManagement\EnumType\NetworkEnum::getValidValues())), __LINE__);
        }
        $this->ExpectedNetwork = $expectedNetwork;
        return $this;
    }
    /**
     * Get ExpectedInstallerLogin value
     * @return string|null
     */
    public function getExpectedInstallerLogin()
    {
        return $this->ExpectedInstallerLogin;
    }
    /**
     * Set ExpectedInstallerLogin value
     * @param string $expectedInstallerLogin
     * @return \CustomerManagement\StructType\UpdateCommitmentInput
     */
    public function setExpectedInstallerLogin($expectedInstallerLogin = null)
    {
        // validation for constraint: string
        if (!is_null($expectedInstallerLogin) && !is_string($expectedInstallerLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expectedInstallerLogin, true), gettype($expectedInstallerLogin)), __LINE__);
        }
        $this->ExpectedInstallerLogin = $expectedInstallerLogin;
        return $this;
    }
}
