<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MergeLoginsInput StructType
 * @subpackage Structs
 */
class MergeLoginsInput extends AbstractStructBase
{
    /**
     * The FirstCustomer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FirstCustomer;
    /**
     * The SecondCustomer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SecondCustomer;
    /**
     * Constructor method for MergeLoginsInput
     * @uses MergeLoginsInput::setFirstCustomer()
     * @uses MergeLoginsInput::setSecondCustomer()
     * @param int $firstCustomer
     * @param int $secondCustomer
     */
    public function __construct($firstCustomer = null, $secondCustomer = null)
    {
        $this
            ->setFirstCustomer($firstCustomer)
            ->setSecondCustomer($secondCustomer);
    }
    /**
     * Get FirstCustomer value
     * @return int
     */
    public function getFirstCustomer()
    {
        return $this->FirstCustomer;
    }
    /**
     * Set FirstCustomer value
     * @param int $firstCustomer
     * @return \CustomerManagement\StructType\MergeLoginsInput
     */
    public function setFirstCustomer($firstCustomer = null)
    {
        // validation for constraint: int
        if (!is_null($firstCustomer) && !(is_int($firstCustomer) || ctype_digit($firstCustomer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($firstCustomer, true), gettype($firstCustomer)), __LINE__);
        }
        $this->FirstCustomer = $firstCustomer;
        return $this;
    }
    /**
     * Get SecondCustomer value
     * @return int
     */
    public function getSecondCustomer()
    {
        return $this->SecondCustomer;
    }
    /**
     * Set SecondCustomer value
     * @param int $secondCustomer
     * @return \CustomerManagement\StructType\MergeLoginsInput
     */
    public function setSecondCustomer($secondCustomer = null)
    {
        // validation for constraint: int
        if (!is_null($secondCustomer) && !(is_int($secondCustomer) || ctype_digit($secondCustomer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($secondCustomer, true), gettype($secondCustomer)), __LINE__);
        }
        $this->SecondCustomer = $secondCustomer;
        return $this;
    }
}
