<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoiceAccessLevelMapping StructType
 * @subpackage Structs
 */
class VoiceAccessLevelMapping extends AbstractStructBase
{
    /**
     * The DeviceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeviceType;
    /**
     * The AccessLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AccessLevel;
    /**
     * Constructor method for VoiceAccessLevelMapping
     * @uses VoiceAccessLevelMapping::setDeviceType()
     * @uses VoiceAccessLevelMapping::setAccessLevel()
     * @param string $deviceType
     * @param string $accessLevel
     */
    public function __construct($deviceType = null, $accessLevel = null)
    {
        $this
            ->setDeviceType($deviceType)
            ->setAccessLevel($accessLevel);
    }
    /**
     * Get DeviceType value
     * @return string
     */
    public function getDeviceType()
    {
        return $this->DeviceType;
    }
    /**
     * Set DeviceType value
     * @uses \CustomerManagement\EnumType\DeviceTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\DeviceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceType
     * @return \CustomerManagement\StructType\VoiceAccessLevelMapping
     */
    public function setDeviceType($deviceType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\DeviceTypeEnum::valueIsValid($deviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\DeviceTypeEnum', is_array($deviceType) ? implode(', ', $deviceType) : var_export($deviceType, true), implode(', ', \CustomerManagement\EnumType\DeviceTypeEnum::getValidValues())), __LINE__);
        }
        $this->DeviceType = $deviceType;
        return $this;
    }
    /**
     * Get AccessLevel value
     * @return string
     */
    public function getAccessLevel()
    {
        return $this->AccessLevel;
    }
    /**
     * Set AccessLevel value
     * @uses \CustomerManagement\EnumType\VoiceAccessLevelEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\VoiceAccessLevelEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accessLevel
     * @return \CustomerManagement\StructType\VoiceAccessLevelMapping
     */
    public function setAccessLevel($accessLevel = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\VoiceAccessLevelEnum::valueIsValid($accessLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\VoiceAccessLevelEnum', is_array($accessLevel) ? implode(', ', $accessLevel) : var_export($accessLevel, true), implode(', ', \CustomerManagement\EnumType\VoiceAccessLevelEnum::getValidValues())), __LINE__);
        }
        $this->AccessLevel = $accessLevel;
        return $this;
    }
}
