<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSensorVoiceDescriptors2GigInput StructType
 * @subpackage Structs
 */
class UpdateSensorVoiceDescriptors2GigInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The SensorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SensorId;
    /**
     * The VoiceDescriptors
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfString
     */
    public $VoiceDescriptors;
    /**
     * Constructor method for UpdateSensorVoiceDescriptors2GigInput
     * @uses UpdateSensorVoiceDescriptors2GigInput::setCustomerId()
     * @uses UpdateSensorVoiceDescriptors2GigInput::setSensorId()
     * @uses UpdateSensorVoiceDescriptors2GigInput::setVoiceDescriptors()
     * @param int $customerId
     * @param int $sensorId
     * @param \CustomerManagement\ArrayType\ArrayOfString $voiceDescriptors
     */
    public function __construct($customerId = null, $sensorId = null, \CustomerManagement\ArrayType\ArrayOfString $voiceDescriptors = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setSensorId($sensorId)
            ->setVoiceDescriptors($voiceDescriptors);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateSensorVoiceDescriptors2GigInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SensorId value
     * @return int
     */
    public function getSensorId()
    {
        return $this->SensorId;
    }
    /**
     * Set SensorId value
     * @param int $sensorId
     * @return \CustomerManagement\StructType\UpdateSensorVoiceDescriptors2GigInput
     */
    public function setSensorId($sensorId = null)
    {
        // validation for constraint: int
        if (!is_null($sensorId) && !(is_int($sensorId) || ctype_digit($sensorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sensorId, true), gettype($sensorId)), __LINE__);
        }
        $this->SensorId = $sensorId;
        return $this;
    }
    /**
     * Get VoiceDescriptors value
     * @return \CustomerManagement\ArrayType\ArrayOfString|null
     */
    public function getVoiceDescriptors()
    {
        return $this->VoiceDescriptors;
    }
    /**
     * Set VoiceDescriptors value
     * @param \CustomerManagement\ArrayType\ArrayOfString $voiceDescriptors
     * @return \CustomerManagement\StructType\UpdateSensorVoiceDescriptors2GigInput
     */
    public function setVoiceDescriptors(\CustomerManagement\ArrayType\ArrayOfString $voiceDescriptors = null)
    {
        $this->VoiceDescriptors = $voiceDescriptors;
        return $this;
    }
}
