<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSimStatusDuringActivationOutput StructType
 * @subpackage Structs
 */
class GetSimStatusDuringActivationOutput extends AbstractStructBase
{
    /**
     * The SimStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SimStatus;
    /**
     * The ErrorStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ErrorStatus;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for GetSimStatusDuringActivationOutput
     * @uses GetSimStatusDuringActivationOutput::setSimStatus()
     * @uses GetSimStatusDuringActivationOutput::setErrorStatus()
     * @uses GetSimStatusDuringActivationOutput::setSuccess()
     * @uses GetSimStatusDuringActivationOutput::setErrorMessage()
     * @param string $simStatus
     * @param string $errorStatus
     * @param bool $success
     * @param string $errorMessage
     */
    public function __construct($simStatus = null, $errorStatus = null, $success = null, $errorMessage = null)
    {
        $this
            ->setSimStatus($simStatus)
            ->setErrorStatus($errorStatus)
            ->setSuccess($success)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get SimStatus value
     * @return string
     */
    public function getSimStatus()
    {
        return $this->SimStatus;
    }
    /**
     * Set SimStatus value
     * @uses \CustomerManagement\EnumType\SimStatusEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\SimStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $simStatus
     * @return \CustomerManagement\StructType\GetSimStatusDuringActivationOutput
     */
    public function setSimStatus($simStatus = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\SimStatusEnum::valueIsValid($simStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\SimStatusEnum', is_array($simStatus) ? implode(', ', $simStatus) : var_export($simStatus, true), implode(', ', \CustomerManagement\EnumType\SimStatusEnum::getValidValues())), __LINE__);
        }
        $this->SimStatus = $simStatus;
        return $this;
    }
    /**
     * Get ErrorStatus value
     * @return string
     */
    public function getErrorStatus()
    {
        return $this->ErrorStatus;
    }
    /**
     * Set ErrorStatus value
     * @uses \CustomerManagement\EnumType\GetSimStatusDuringActivationErrorEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\GetSimStatusDuringActivationErrorEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorStatus
     * @return \CustomerManagement\StructType\GetSimStatusDuringActivationOutput
     */
    public function setErrorStatus($errorStatus = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\GetSimStatusDuringActivationErrorEnum::valueIsValid($errorStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\GetSimStatusDuringActivationErrorEnum', is_array($errorStatus) ? implode(', ', $errorStatus) : var_export($errorStatus, true), implode(', ', \CustomerManagement\EnumType\GetSimStatusDuringActivationErrorEnum::getValidValues())), __LINE__);
        }
        $this->ErrorStatus = $errorStatus;
        return $this;
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetSimStatusDuringActivationOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetSimStatusDuringActivationOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
}
