<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadedPanelSetting StructType
 * @subpackage Structs
 */
class UploadedPanelSetting extends AbstractStructBase
{
    /**
     * The PanelSettingId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PanelSettingId;
    /**
     * The DeviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * The UploadDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $UploadDate;
    /**
     * The PanelSettingName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PanelSettingName;
    /**
     * The UploadedValueRaw
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UploadedValueRaw;
    /**
     * The UploadedValueDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UploadedValueDesc;
    /**
     * Constructor method for UploadedPanelSetting
     * @uses UploadedPanelSetting::setPanelSettingId()
     * @uses UploadedPanelSetting::setDeviceId()
     * @uses UploadedPanelSetting::setUploadDate()
     * @uses UploadedPanelSetting::setPanelSettingName()
     * @uses UploadedPanelSetting::setUploadedValueRaw()
     * @uses UploadedPanelSetting::setUploadedValueDesc()
     * @param int $panelSettingId
     * @param int $deviceId
     * @param string $uploadDate
     * @param string $panelSettingName
     * @param string $uploadedValueRaw
     * @param string $uploadedValueDesc
     */
    public function __construct($panelSettingId = null, $deviceId = null, $uploadDate = null, $panelSettingName = null, $uploadedValueRaw = null, $uploadedValueDesc = null)
    {
        $this
            ->setPanelSettingId($panelSettingId)
            ->setDeviceId($deviceId)
            ->setUploadDate($uploadDate)
            ->setPanelSettingName($panelSettingName)
            ->setUploadedValueRaw($uploadedValueRaw)
            ->setUploadedValueDesc($uploadedValueDesc);
    }
    /**
     * Get PanelSettingId value
     * @return int
     */
    public function getPanelSettingId()
    {
        return $this->PanelSettingId;
    }
    /**
     * Set PanelSettingId value
     * @param int $panelSettingId
     * @return \CustomerManagement\StructType\UploadedPanelSetting
     */
    public function setPanelSettingId($panelSettingId = null)
    {
        // validation for constraint: int
        if (!is_null($panelSettingId) && !(is_int($panelSettingId) || ctype_digit($panelSettingId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($panelSettingId, true), gettype($panelSettingId)), __LINE__);
        }
        $this->PanelSettingId = $panelSettingId;
        return $this;
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\UploadedPanelSetting
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !(is_int($deviceId) || ctype_digit($deviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get UploadDate value
     * @return string
     */
    public function getUploadDate()
    {
        return $this->UploadDate;
    }
    /**
     * Set UploadDate value
     * @param string $uploadDate
     * @return \CustomerManagement\StructType\UploadedPanelSetting
     */
    public function setUploadDate($uploadDate = null)
    {
        // validation for constraint: string
        if (!is_null($uploadDate) && !is_string($uploadDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uploadDate, true), gettype($uploadDate)), __LINE__);
        }
        $this->UploadDate = $uploadDate;
        return $this;
    }
    /**
     * Get PanelSettingName value
     * @return string|null
     */
    public function getPanelSettingName()
    {
        return $this->PanelSettingName;
    }
    /**
     * Set PanelSettingName value
     * @param string $panelSettingName
     * @return \CustomerManagement\StructType\UploadedPanelSetting
     */
    public function setPanelSettingName($panelSettingName = null)
    {
        // validation for constraint: string
        if (!is_null($panelSettingName) && !is_string($panelSettingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($panelSettingName, true), gettype($panelSettingName)), __LINE__);
        }
        $this->PanelSettingName = $panelSettingName;
        return $this;
    }
    /**
     * Get UploadedValueRaw value
     * @return string|null
     */
    public function getUploadedValueRaw()
    {
        return $this->UploadedValueRaw;
    }
    /**
     * Set UploadedValueRaw value
     * @param string $uploadedValueRaw
     * @return \CustomerManagement\StructType\UploadedPanelSetting
     */
    public function setUploadedValueRaw($uploadedValueRaw = null)
    {
        // validation for constraint: string
        if (!is_null($uploadedValueRaw) && !is_string($uploadedValueRaw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uploadedValueRaw, true), gettype($uploadedValueRaw)), __LINE__);
        }
        $this->UploadedValueRaw = $uploadedValueRaw;
        return $this;
    }
    /**
     * Get UploadedValueDesc value
     * @return string|null
     */
    public function getUploadedValueDesc()
    {
        return $this->UploadedValueDesc;
    }
    /**
     * Set UploadedValueDesc value
     * @param string $uploadedValueDesc
     * @return \CustomerManagement\StructType\UploadedPanelSetting
     */
    public function setUploadedValueDesc($uploadedValueDesc = null)
    {
        // validation for constraint: string
        if (!is_null($uploadedValueDesc) && !is_string($uploadedValueDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uploadedValueDesc, true), gettype($uploadedValueDesc)), __LINE__);
        }
        $this->UploadedValueDesc = $uploadedValueDesc;
        return $this;
    }
}
