<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestRemoteRoutineInspectionOutput StructType
 * @subpackage Structs
 */
class RequestRemoteRoutineInspectionOutput extends AbstractStructBase
{
    /**
     * The RRIInstanceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RRIInstanceCode;
    /**
     * The ResultCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ResultCode;
    /**
     * Constructor method for RequestRemoteRoutineInspectionOutput
     * @uses RequestRemoteRoutineInspectionOutput::setRRIInstanceCode()
     * @uses RequestRemoteRoutineInspectionOutput::setResultCode()
     * @param int $rRIInstanceCode
     * @param string $resultCode
     */
    public function __construct($rRIInstanceCode = null, $resultCode = null)
    {
        $this
            ->setRRIInstanceCode($rRIInstanceCode)
            ->setResultCode($resultCode);
    }
    /**
     * Get RRIInstanceCode value
     * @return int
     */
    public function getRRIInstanceCode()
    {
        return $this->RRIInstanceCode;
    }
    /**
     * Set RRIInstanceCode value
     * @param int $rRIInstanceCode
     * @return \CustomerManagement\StructType\RequestRemoteRoutineInspectionOutput
     */
    public function setRRIInstanceCode($rRIInstanceCode = null)
    {
        // validation for constraint: int
        if (!is_null($rRIInstanceCode) && !(is_int($rRIInstanceCode) || ctype_digit($rRIInstanceCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rRIInstanceCode, true), gettype($rRIInstanceCode)), __LINE__);
        }
        $this->RRIInstanceCode = $rRIInstanceCode;
        return $this;
    }
    /**
     * Get ResultCode value
     * @return string
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @uses \CustomerManagement\EnumType\RRIRequestResultEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\RRIRequestResultEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resultCode
     * @return \CustomerManagement\StructType\RequestRemoteRoutineInspectionOutput
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\RRIRequestResultEnum::valueIsValid($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\RRIRequestResultEnum', is_array($resultCode) ? implode(', ', $resultCode) : var_export($resultCode, true), implode(', ', \CustomerManagement\EnumType\RRIRequestResultEnum::getValidValues())), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
}
